/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.http.HttpRouteStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record HttpStats(long serverOpen, long totalOpen, List<ClientStats> clientStats, Map<String, HttpRouteStats> httpRouteStats) implements Writeable,
ChunkedToXContent
{
    public static final HttpStats IDENTITY = new HttpStats(0L, 0L, List.of(), Map.of());

    public HttpStats(long serverOpen, long totalOpened) {
        this(serverOpen, totalOpened, List.of(), Map.of());
    }

    public HttpStats(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong(), in.readCollectionAsList(ClientStats::new), in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readMap(HttpRouteStats::new) : Map.of());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        out.writeVLong(this.totalOpen);
        out.writeCollection(this.clientStats);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeMap(this.httpRouteStats, StreamOutput::writeWriteable);
        }
    }

    public long getServerOpen() {
        return this.serverOpen;
    }

    public long getTotalOpen() {
        return this.totalOpen;
    }

    public List<ClientStats> getClientStats() {
        return this.clientStats;
    }

    public static HttpStats merge(HttpStats first, HttpStats second) {
        return new HttpStats(first.serverOpen + second.serverOpen, first.totalOpen + second.totalOpen, Stream.concat(first.clientStats.stream(), second.clientStats.stream()).toList(), Stream.concat(first.httpRouteStats.entrySet().stream(), second.httpRouteStats.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, HttpRouteStats::merge)));
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(Iterators.single((builder, params) -> builder.startObject("http").field("current_open", this.serverOpen).field("total_opened", this.totalOpen).startArray("clients")), this.clientStats.iterator(), Iterators.single((builder, params) -> {
            builder.endArray();
            builder.startObject("routes");
            return builder;
        }), Iterators.map(this.httpRouteStats.entrySet().iterator(), entry -> (builder, params) -> {
            builder.field((String)entry.getKey());
            ((HttpRouteStats)entry.getValue()).toXContent(builder, params);
            return builder;
        }), Iterators.single((builder, params) -> builder.endObject().endObject()));
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String CURRENT_OPEN = "current_open";
        static final String TOTAL_OPENED = "total_opened";
        static final String CLIENTS = "clients";
        static final String CLIENT_ID = "id";
        static final String CLIENT_AGENT = "agent";
        static final String CLIENT_LOCAL_ADDRESS = "local_address";
        static final String CLIENT_REMOTE_ADDRESS = "remote_address";
        static final String CLIENT_LAST_URI = "last_uri";
        static final String CLIENT_OPENED_TIME_MILLIS = "opened_time_millis";
        static final String CLIENT_CLOSED_TIME_MILLIS = "closed_time_millis";
        static final String CLIENT_LAST_REQUEST_TIME_MILLIS = "last_request_time_millis";
        static final String CLIENT_REQUEST_COUNT = "request_count";
        static final String CLIENT_REQUEST_SIZE_BYTES = "request_size_bytes";
        static final String CLIENT_FORWARDED_FOR = "x_forwarded_for";
        static final String CLIENT_OPAQUE_ID = "x_opaque_id";
        static final String ROUTES = "routes";

        Fields() {
        }
    }

    public record ClientStats(int id, String agent, String localAddress, String remoteAddress, String lastUri, String forwardedFor, String opaqueId, long openedTimeMillis, long closedTimeMillis, long lastRequestTimeMillis, long requestCount, long requestSizeBytes) implements Writeable,
    ToXContentFragment
    {
        public static final long NOT_CLOSED = -1L;

        ClientStats(StreamInput in) throws IOException {
            this(in.readInt(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            if (this.agent != null) {
                builder.field("agent", this.agent);
            }
            if (this.localAddress != null) {
                builder.field("local_address", this.localAddress);
            }
            if (this.remoteAddress != null) {
                builder.field("remote_address", this.remoteAddress);
            }
            if (this.lastUri != null) {
                builder.field("last_uri", this.lastUri);
            }
            if (this.forwardedFor != null) {
                builder.field("x_forwarded_for", this.forwardedFor);
            }
            if (this.opaqueId != null) {
                builder.field("x_opaque_id", this.opaqueId);
            }
            builder.field("opened_time_millis", this.openedTimeMillis);
            if (this.closedTimeMillis != -1L) {
                builder.field("closed_time_millis", this.closedTimeMillis);
            }
            builder.field("last_request_time_millis", this.lastRequestTimeMillis);
            builder.field("request_count", this.requestCount);
            builder.field("request_size_bytes", this.requestSizeBytes);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.id);
            out.writeOptionalString(this.agent);
            out.writeOptionalString(this.localAddress);
            out.writeOptionalString(this.remoteAddress);
            out.writeOptionalString(this.lastUri);
            out.writeOptionalString(this.forwardedFor);
            out.writeOptionalString(this.opaqueId);
            out.writeLong(this.openedTimeMillis);
            out.writeLong(this.closedTimeMillis);
            out.writeLong(this.lastRequestTimeMillis);
            out.writeLong(this.requestCount);
            out.writeLong(this.requestSizeBytes);
        }
    }
}

