/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.ListenableActionFuture;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.TaskCancelledException;

public abstract class CancellableSingleObjectCache<Input, Key, Value> {
    private final ThreadContext threadContext;
    private final AtomicReference<CachedItem> currentCachedItemRef = new AtomicReference();

    protected CancellableSingleObjectCache(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    protected abstract void refresh(Input var1, Runnable var2, BooleanSupplier var3, ActionListener<Value> var4);

    protected abstract Key getKey(Input var1);

    protected boolean isFresh(Key currentKey, Key newKey) {
        return currentKey.equals(newKey);
    }

    protected final void clearCurrentCachedItem() {
        this.currentCachedItemRef.set(null);
    }

    public final void get(Input input, BooleanSupplier isCancelled, ActionListener<Value> listener) {
        boolean listenerAdded;
        CachedItem currentCachedItem;
        Key key = this.getKey(input);
        CachedItem newCachedItem = null;
        while (true) {
            if (isCancelled.getAsBoolean()) {
                listener.onFailure(new TaskCancelledException("task cancelled"));
                return;
            }
            currentCachedItem = this.currentCachedItemRef.get();
            if (currentCachedItem != null && this.isFresh(currentCachedItem.getKey(), key)) {
                listenerAdded = currentCachedItem.addListener(listener, isCancelled);
                if (listenerAdded) {
                    return;
                }
                assert (currentCachedItem.refCount() == 0) : currentCachedItem.refCount();
                assert (this.currentCachedItemRef.get() != currentCachedItem);
                ListenableActionFuture future = currentCachedItem.getFuture();
                if (!future.isDone()) continue;
                try {
                    listener.onResponse(future.actionResult());
                    return;
                }
                catch (TaskCancelledException taskCancelledException) {
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return;
                }
            }
            if (newCachedItem == null) {
                newCachedItem = new CachedItem(key);
            }
            if (this.currentCachedItemRef.compareAndSet(currentCachedItem, newCachedItem)) break;
        }
        if (currentCachedItem != null) {
            currentCachedItem.decRef();
        }
        listenerAdded = newCachedItem.addListener(listener, isCancelled);
        assert (listenerAdded);
        newCachedItem.decRef();
        newCachedItem.startRefresh(input);
    }

    private final class CachedItem
    extends AbstractRefCounted {
        private final Key key;
        private final ListenableActionFuture<Value> future = new ListenableActionFuture();
        private final CancellationChecks cancellationChecks = new CancellationChecks();

        CachedItem(Key key) {
            this.key = key;
            this.mustIncRef();
            this.future.addListener(new ActionListener<Value>(){

                @Override
                public void onResponse(Value value) {
                    CachedItem.this.cancellationChecks.clear();
                }

                @Override
                public void onFailure(Exception e) {
                    CachedItem.this.cancellationChecks.clear();
                    if (CancellableSingleObjectCache.this.currentCachedItemRef.compareAndSet(CachedItem.this, null)) {
                        CachedItem.this.decRef();
                    }
                }
            });
        }

        Key getKey() {
            return this.key;
        }

        ListenableActionFuture<Value> getFuture() {
            return this.future;
        }

        boolean addListener(ActionListener<Value> listener, BooleanSupplier isCancelled) {
            if (this.tryIncRef()) {
                if (this.future.isDone()) {
                    ActionListener.completeWith(listener, this.future::actionResult);
                } else {
                    ActionListener cancellableListener = ActionListener.notifyOnce(ContextPreservingActionListener.wrapPreservingContext(listener, CancellableSingleObjectCache.this.threadContext));
                    this.future.addListener(cancellableListener);
                    AtomicBoolean released = new AtomicBoolean();
                    this.cancellationChecks.add(() -> {
                        if (!released.get() && isCancelled.getAsBoolean() && released.compareAndSet(false, true)) {
                            this.decRef();
                            cancellableListener.onFailure(new TaskCancelledException("task cancelled"));
                        }
                    });
                }
                return true;
            }
            return false;
        }

        private void ensureNotCancelled() {
            this.cancellationChecks.runAll();
            if (!this.hasReferences()) {
                throw new TaskCancelledException("task cancelled");
            }
        }

        protected void closeInternal() {
            this.future.onFailure(new TaskCancelledException("task cancelled"));
        }

        private boolean supersedeIfStale() {
            CachedItem currentCachedItem = CancellableSingleObjectCache.this.currentCachedItemRef.get();
            if (currentCachedItem == this) {
                return false;
            }
            if (currentCachedItem == null) {
                return false;
            }
            this.cancellationChecks.runAll();
            if (this.tryIncRef()) {
                try {
                    boolean bl = currentCachedItem.addListener(this.future, () -> {
                        this.cancellationChecks.runAll();
                        return !this.hasReferences();
                    });
                    return bl;
                }
                finally {
                    this.decRef();
                }
            }
            return false;
        }

        void startRefresh(Input input) {
            try {
                CancellableSingleObjectCache.this.refresh(input, this::ensureNotCancelled, this::supersedeIfStale, this.future);
            }
            catch (Exception e) {
                this.future.onFailure(e);
            }
        }
    }

    private static final class CancellationChecks {
        @Nullable
        private ArrayList<Runnable> checks = new ArrayList();

        private CancellationChecks() {
        }

        synchronized void clear() {
            this.checks = null;
        }

        synchronized void add(Runnable check) {
            if (this.checks != null) {
                this.checks.add(check);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runAll() {
            int count;
            CancellationChecks cancellationChecks = this;
            synchronized (cancellationChecks) {
                if (this.checks == null) {
                    return;
                }
                count = this.checks.size();
            }
            for (int i = 0; i < count; ++i) {
                Runnable cancellationCheck;
                CancellationChecks cancellationChecks2 = this;
                synchronized (cancellationChecks2) {
                    if (this.checks == null) {
                        return;
                    }
                    cancellationCheck = this.checks.get(i);
                }
                cancellationCheck.run();
            }
        }
    }
}

