/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.AbstractBigByteArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.core.Streams;

final class BigByteArray
extends AbstractBigByteArray
implements ByteArray {
    private static final BigByteArray ESTIMATOR = new BigByteArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    private static final int PAGE_SHIFT = Integer.numberOfTrailingZeros(16384);

    BigByteArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(16384, bigArrays, clearOnResize, size);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        BigLongArray.writePages(out, this.size, this.pages, 1);
    }

    @Override
    public byte get(long index) {
        int pageIndex = BigByteArray.pageIdx(index);
        int indexInPage = BigByteArray.idxInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public void set(long index, byte value) {
        int pageIndex = BigByteArray.pageIdx(index);
        int indexInPage = BigByteArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        page[indexInPage] = value;
    }

    @Override
    public boolean get(long index, int len, BytesRef ref) {
        assert (index + (long)len <= this.size());
        if (len == 0) {
            ref.length = 0;
            return false;
        }
        int pageIndex = BigByteArray.pageIdx(index);
        int indexInPage = BigByteArray.idxInPage(index);
        if (indexInPage + len <= 16384) {
            ref.bytes = this.pages[pageIndex];
            ref.offset = indexInPage;
            ref.length = len;
            return false;
        }
        ref.bytes = new byte[len];
        ref.offset = 0;
        ref.length = 16384 - indexInPage;
        System.arraycopy(this.pages[pageIndex], indexInPage, ref.bytes, 0, ref.length);
        do {
            int copyLength = Math.min(16384, len - ref.length);
            System.arraycopy(this.pages[++pageIndex], 0, ref.bytes, ref.length, copyLength);
            ref.length += copyLength;
        } while (ref.length < len);
        return true;
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        assert (index + (long)len <= this.size());
        int pageIndex = BigByteArray.pageIdx(index);
        int indexInPage = BigByteArray.idxInPage(index);
        if (indexInPage + len <= 16384) {
            System.arraycopy(buf, offset, this.getPageForWriting(pageIndex), indexInPage, len);
        } else {
            int copyLen = 16384 - indexInPage;
            System.arraycopy(buf, offset, this.getPageForWriting(pageIndex), indexInPage, copyLen);
            do {
                copyLen = Math.min(len -= copyLen, 16384);
                System.arraycopy(buf, offset += copyLen, this.getPageForWriting(++pageIndex), 0, copyLen);
            } while (len > copyLen);
        }
    }

    @Override
    public void fill(long fromIndex, long toIndex, byte value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = BigByteArray.pageIdx(fromIndex);
        if (fromPage == (toPage = BigByteArray.pageIdx(toIndex - 1L))) {
            Arrays.fill(this.getPageForWriting(fromPage), BigByteArray.idxInPage(fromIndex), BigByteArray.idxInPage(toIndex - 1L) + 1, value);
        } else {
            Arrays.fill(this.getPageForWriting(fromPage), BigByteArray.idxInPage(fromIndex), this.pages[fromPage].length, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.getPageForWriting(i), value);
            }
            Arrays.fill(this.getPageForWriting(toPage), 0, BigByteArray.idxInPage(toIndex - 1L) + 1, value);
        }
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        assert (false);
        throw new UnsupportedOperationException();
    }

    @Override
    public BytesRefIterator iterator() {
        return new BytesRefIterator(){
            int i = 0;
            long remained;
            {
                this.remained = BigByteArray.this.size;
            }

            public BytesRef next() {
                if (this.remained == 0L) {
                    return null;
                }
                byte[] page = BigByteArray.this.pages[this.i++];
                int len = Math.toIntExact(Math.min((long)page.length, this.remained));
                this.remained -= (long)len;
                return new BytesRef(page, 0, len);
            }
        };
    }

    @Override
    public void fillWith(InputStream in) throws IOException {
        for (int i = 0; i < this.pages.length - 1; ++i) {
            Streams.readFully((InputStream)in, (byte[])this.getPageForWriting(i), (int)0, (int)16384);
        }
        Streams.readFully((InputStream)in, (byte[])this.getPageForWriting(this.pages.length - 1), (int)0, (int)Math.toIntExact(this.size - ((long)this.pages.length - 1L) * 16384L));
    }

    @Override
    protected int numBytesPerElement() {
        return 1;
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }

    private static int pageIdx(long index) {
        return (int)(index >>> PAGE_SHIFT);
    }

    private static int idxInPage(long index) {
        return (int)(index & 0x3FFFL);
    }
}

