/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.project;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ToXContent;

public class ProjectStateRegistry
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "projects_registry";
    public static final ProjectStateRegistry EMPTY = new ProjectStateRegistry(Collections.emptyMap());
    private static final TransportVersion CLUSTER_STATE_PROJECTS_SETTINGS = TransportVersion.fromName("cluster_state_projects_settings");
    private final Map<ProjectId, Settings> projectsSettings;

    public ProjectStateRegistry(StreamInput in) throws IOException {
        this.projectsSettings = in.readMap(ProjectId::readFrom, Settings::readSettingsFromStream);
    }

    private ProjectStateRegistry(Map<ProjectId, Settings> projectsSettings) {
        this.projectsSettings = projectsSettings;
    }

    public static Settings getProjectSettings(ProjectId projectId, ClusterState clusterState) {
        ProjectStateRegistry registry = clusterState.custom(TYPE, EMPTY);
        return registry.projectsSettings.getOrDefault(projectId, Settings.EMPTY);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        boolean multiProject = params.paramAsBoolean("multi-project", false);
        if (!multiProject) {
            return Collections.emptyIterator();
        }
        return Iterators.concat(Iterators.single((builder, p) -> builder.startArray("projects")), Iterators.map(this.projectsSettings.entrySet().iterator(), entry -> (builder, p) -> {
            builder.startObject();
            builder.field("id", (ToXContent)entry.getKey());
            builder.startObject("settings");
            ((Settings)entry.getValue()).toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
            builder.endObject();
            return builder.endObject();
        }), Iterators.single((builder, p) -> builder.endArray()));
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return ProjectStateRegistry.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return CLUSTER_STATE_PROJECTS_SETTINGS;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.projectsSettings);
    }

    public int size() {
        return this.projectsSettings.size();
    }

    public static Builder builder(ClusterState original) {
        ProjectStateRegistry projectRegistry = original.custom(TYPE, EMPTY);
        return ProjectStateRegistry.builder(projectRegistry);
    }

    public static Builder builder(ProjectStateRegistry projectRegistry) {
        return new Builder(projectRegistry);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableOpenMap.Builder<ProjectId, Settings> projectsSettings;

        private Builder() {
            this.projectsSettings = ImmutableOpenMap.builder();
        }

        private Builder(ProjectStateRegistry original) {
            this.projectsSettings = ImmutableOpenMap.builder(original.projectsSettings);
        }

        public Builder putProjectSettings(ProjectId projectId, Settings settings) {
            this.projectsSettings.put(projectId, settings);
            return this;
        }

        public ProjectStateRegistry build() {
            return new ProjectStateRegistry(this.projectsSettings.build());
        }
    }
}

