/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.IndexReshardingState;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class IndexReshardingMetadata
implements ToXContentFragment,
Writeable {
    private static final String SPLIT_FIELD_NAME = "split";
    private static final ParseField SPLIT_FIELD = new ParseField("split", new String[0]);
    private static final String NOOP_FIELD_NAME = "noop";
    private static final ParseField NOOP_FIELD = new ParseField("noop", new String[0]);
    private static final ConstructingObjectParser<IndexReshardingMetadata, Void> PARSER = new ConstructingObjectParser("index_resharding_metadata", args -> {
        if (args[0] != null) {
            return new IndexReshardingMetadata((IndexReshardingState)args[0]);
        }
        return new IndexReshardingMetadata((IndexReshardingState)args[1]);
    });
    private final IndexReshardingState state;

    IndexReshardingMetadata(IndexReshardingState state) {
        this.state = state;
    }

    public IndexReshardingMetadata(StreamInput in) throws IOException {
        String stateName;
        this.state = switch (stateName = in.readString()) {
            case NOOP_FIELD_NAME -> new IndexReshardingState.Noop(in);
            case SPLIT_FIELD_NAME -> new IndexReshardingState.Split(in);
            default -> throw new IllegalStateException("unknown operation [" + stateName + "]");
        };
    }

    IndexReshardingState getState() {
        return this.state;
    }

    static IndexReshardingMetadata fromXContent(XContentParser parser) throws IOException {
        return (IndexReshardingMetadata)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        IndexReshardingState indexReshardingState = this.state;
        Objects.requireNonNull(indexReshardingState);
        IndexReshardingState indexReshardingState2 = indexReshardingState;
        int n = 0;
        String name = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IndexReshardingState.Noop.class, IndexReshardingState.Split.class}, (Object)indexReshardingState2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                IndexReshardingState.Noop ignored = (IndexReshardingState.Noop)indexReshardingState2;
                yield NOOP_FIELD.getPreferredName();
            }
            case 1 -> {
                IndexReshardingState.Split ignored = (IndexReshardingState.Split)indexReshardingState2;
                yield SPLIT_FIELD.getPreferredName();
            }
        };
        builder.startObject(name);
        this.state.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        IndexReshardingState indexReshardingState = this.state;
        Objects.requireNonNull(indexReshardingState);
        IndexReshardingState indexReshardingState2 = indexReshardingState;
        int n = 0;
        String name = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IndexReshardingState.Noop.class, IndexReshardingState.Split.class}, (Object)indexReshardingState2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                IndexReshardingState.Noop ignored = (IndexReshardingState.Noop)indexReshardingState2;
                yield NOOP_FIELD.getPreferredName();
            }
            case 1 -> {
                IndexReshardingState.Split ignored = (IndexReshardingState.Split)indexReshardingState2;
                yield SPLIT_FIELD.getPreferredName();
            }
        };
        out.writeString(name);
        this.state.writeTo(out);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IndexReshardingMetadata otherMetadata = (IndexReshardingMetadata)other;
        return Objects.equals(this.state, otherMetadata.state);
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }

    public String toString() {
        return "IndexReshardingMetadata [state=" + String.valueOf(this.state) + "]";
    }

    public static IndexReshardingMetadata newSplitByMultiple(int shardCount, int multiple) {
        return new IndexReshardingMetadata(IndexReshardingState.Split.newSplitByMultiple(shardCount, multiple));
    }

    public static boolean isSplitTarget(ShardId shardId, @Nullable IndexReshardingMetadata reshardingMetadata) {
        return reshardingMetadata != null && reshardingMetadata.isSplit() && reshardingMetadata.getSplit().isTargetShard(shardId.id());
    }

    public IndexReshardingMetadata transitionSplitTargetToNewState(ShardId shardId, IndexReshardingState.Split.TargetShardState newTargetState) {
        assert (this.state instanceof IndexReshardingState.Split);
        IndexReshardingState.Split.Builder builder = new IndexReshardingState.Split.Builder((IndexReshardingState.Split)this.state);
        builder.setTargetShardState(shardId.getId(), newTargetState);
        return new IndexReshardingMetadata(builder.build());
    }

    public IndexReshardingState.Split getSplit() {
        IndexReshardingState indexReshardingState = this.state;
        Objects.requireNonNull(indexReshardingState);
        IndexReshardingState indexReshardingState2 = indexReshardingState;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IndexReshardingState.Noop.class, IndexReshardingState.Split.class}, (Object)indexReshardingState2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                IndexReshardingState.Noop ignored = (IndexReshardingState.Noop)indexReshardingState2;
                throw new IllegalArgumentException("resharding metadata is not a split");
            }
            case 1: 
        }
        IndexReshardingState.Split s = (IndexReshardingState.Split)indexReshardingState2;
        return s;
    }

    public boolean isSplit() {
        return this.state instanceof IndexReshardingState.Split;
    }

    public int shardCountBefore() {
        return this.state.shardCountBefore();
    }

    public int shardCountAfter() {
        return this.state.shardCountAfter();
    }

    static {
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> IndexReshardingState.Split.fromXContent(parser), null, SPLIT_FIELD);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> IndexReshardingState.Noop.fromXContent(parser), null, NOOP_FIELD);
        PARSER.declareExclusiveFieldSet(new String[]{SPLIT_FIELD.getPreferredName(), NOOP_FIELD.getPreferredName()});
        PARSER.declareRequiredFieldSet(new String[]{SPLIT_FIELD.getPreferredName(), NOOP_FIELD.getPreferredName()});
    }
}

