/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.master.ShardsAcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class CreateIndexResponse
extends ShardsAcknowledgedResponse {
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    private final String index;

    public CreateIndexResponse(StreamInput in) throws IOException {
        super(in, true);
        this.index = in.readString();
    }

    public CreateIndexResponse(boolean acknowledged, boolean shardsAcknowledged, String index) {
        super(acknowledged, shardsAcknowledged);
        this.index = Objects.requireNonNull(index);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeShardsAcknowledged(out);
        out.writeString(this.index);
    }

    public String index() {
        return this.index;
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.field(INDEX.getPreferredName(), this.index());
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            CreateIndexResponse that = (CreateIndexResponse)o;
            return Objects.equals(this.index, that.index);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.index);
    }
}

