/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.hotthreads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.transport.LeakTracker;

public class NodesHotThreadsResponse
extends BaseNodesResponse<NodeHotThreads> {
    private final RefCounted refs = LeakTracker.wrap((RefCounted)AbstractRefCounted.of(() -> Releasables.wrap(Iterators.map(this.getNodes().iterator(), n -> n::decRef)).close()));

    public NodesHotThreadsResponse(ClusterName clusterName, List<NodeHotThreads> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
        for (NodeHotThreads nodeHotThreads : this.getNodes()) {
            nodeHotThreads.mustIncRef();
        }
    }

    public Iterator<CheckedConsumer<Writer, IOException>> getTextChunks() {
        return Iterators.flatMap(this.getNodes().iterator(), node -> Iterators.concat(Iterators.single(writer -> writer.append("::: ").append(node.getNode().toString()).append('\n')), Iterators.map(new LinesIterator(node.getHotThreadsReader()), line -> writer -> writer.append("   ").append((CharSequence)line).append('\n')), Iterators.single(writer -> {
            assert (this.hasReferences());
            writer.append('\n');
        })));
    }

    @Override
    protected List<NodeHotThreads> readNodesFrom(StreamInput in) throws IOException {
        return (List)TransportAction.localOnly();
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeHotThreads> nodes) throws IOException {
        TransportAction.localOnly();
    }

    @Override
    public void incRef() {
        this.refs.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refs.tryIncRef();
    }

    @Override
    public boolean decRef() {
        return this.refs.decRef();
    }

    @Override
    public boolean hasReferences() {
        return this.refs.hasReferences();
    }

    private static class LinesIterator
    implements Iterator<String> {
        final BufferedReader reader;
        String nextLine;

        private LinesIterator(Reader reader) {
            this.reader = new BufferedReader(reader);
            this.advance();
        }

        private void advance() {
            block2: {
                try {
                    this.nextLine = this.reader.readLine();
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)e);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public String next() {
            if (this.nextLine == null) {
                throw new NoSuchElementException();
            }
            try {
                String string = this.nextLine;
                return string;
            }
            finally {
                this.advance();
            }
        }
    }
}

