/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota;

import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class MultipartBody
implements Parsable {
    @Nonnull
    private final String boundary = UUID.randomUUID().toString().replace("-", "");
    @Nullable
    public RequestAdapter requestAdapter;
    private final Map<String, Part> parts = new HashMap<String, Part>();

    @Nonnull
    public String getBoundary() {
        return this.boundary;
    }

    public <T> void addOrReplacePart(@Nonnull String name, @Nonnull String contentType, @Nonnull T value) {
        this.addOrReplacePart(name, contentType, value, null);
    }

    public <T> void addOrReplacePart(@Nonnull String name, @Nonnull String contentType, @Nonnull T value, @Nullable String filename) {
        Objects.requireNonNull(value);
        if (Compatibility.isBlank(contentType)) {
            throw new IllegalArgumentException("contentType cannot be blank or empty");
        }
        if (Compatibility.isBlank(name)) {
            throw new IllegalArgumentException("name cannot be blank or empty");
        }
        String normalizedName = this.normalizePartName(name);
        Part part = new Part(name, value, contentType, filename);
        this.parts.put(normalizedName, part);
    }

    private String normalizePartName(@Nonnull String original) {
        return original.toLowerCase(Locale.ROOT);
    }

    @Nullable
    public Object getPartValue(@Nonnull String partName) {
        if (Compatibility.isBlank(partName)) {
            throw new IllegalArgumentException("partName cannot be blank or empty");
        }
        String normalizedName = this.normalizePartName(partName);
        Part candidate = this.parts.get(normalizedName);
        if (candidate == null) {
            return null;
        }
        return candidate.getValue();
    }

    public boolean removePart(@Nonnull String partName) {
        if (Compatibility.isBlank(partName)) {
            throw new IllegalArgumentException("partName cannot be blank or empty");
        }
        String normalizedName = this.normalizePartName(partName);
        Part candidate = this.parts.remove(normalizedName);
        return candidate != null;
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        throw new UnsupportedOperationException("Unimplemented method 'getFieldDeserializers'");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        RequestAdapter ra = this.requestAdapter;
        if (ra == null) {
            throw new IllegalStateException("requestAdapter cannot be null");
        }
        if (this.parts.isEmpty()) {
            throw new IllegalStateException("multipart body cannot be empty");
        }
        SerializationWriterFactory serializationFactory = ra.getSerializationWriterFactory();
        boolean isFirst = true;
        for (Map.Entry<String, Part> partEntry : this.parts.entrySet()) {
            try {
                Part part = partEntry.getValue();
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.writeStringValue("", "");
                }
                writer.writeStringValue("", "--" + this.getBoundary());
                String partContentType = part.getContentType();
                writer.writeStringValue("Content-Type", partContentType);
                String contentDisposition = "form-data; name=\"" + part.getName() + "\"";
                if (part.getFilename() != null && !part.getFilename().trim().isEmpty()) {
                    contentDisposition = contentDisposition + "; filename=\"" + part.getFilename() + "\"";
                }
                writer.writeStringValue("Content-Disposition", contentDisposition);
                writer.writeStringValue("", "");
                Object objectValue = part.getValue();
                if (objectValue instanceof Parsable) {
                    SerializationWriter partWriter = serializationFactory.getSerializationWriter(partContentType);
                    try {
                        partWriter.writeObjectValue("", (Parsable)objectValue, new Parsable[0]);
                        InputStream partContent = partWriter.getSerializedContent();
                        try {
                            if (partContent.markSupported()) {
                                partContent.reset();
                            }
                            writer.writeByteArrayValue("", Compatibility.readAllBytes(partContent));
                            continue;
                        }
                        finally {
                            if (partContent != null) {
                                partContent.close();
                            }
                            continue;
                        }
                    }
                    finally {
                        if (partWriter == null) continue;
                        partWriter.close();
                        continue;
                    }
                }
                if (objectValue instanceof String) {
                    writer.writeStringValue("", (String)objectValue);
                    continue;
                }
                if (objectValue instanceof InputStream) {
                    InputStream inputStream = (InputStream)objectValue;
                    if (inputStream.markSupported()) {
                        inputStream.reset();
                    }
                    writer.writeByteArrayValue("", Compatibility.readAllBytes(inputStream));
                    continue;
                }
                if (objectValue instanceof byte[]) {
                    writer.writeByteArrayValue("", (byte[])objectValue);
                    continue;
                }
                throw new IllegalStateException("Unsupported part type" + objectValue.getClass().getName());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        writer.writeStringValue("", "");
        writer.writeStringValue("", "--" + this.boundary + "--");
    }

    private class Part {
        private final String name;
        private final Object value;
        private final String contentType;
        private final String filename;

        Part(String name, Object value, String contentType, String filename) {
            this.name = name;
            this.value = value;
            this.contentType = contentType;
            this.filename = filename;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

