/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse;
import software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord;

public class GetIpamAddressHistoryIterable
implements SdkIterable<GetIpamAddressHistoryResponse> {
    private final Ec2Client client;
    private final GetIpamAddressHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIpamAddressHistoryIterable(Ec2Client client, GetIpamAddressHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetIpamAddressHistoryResponseFetcher();
    }

    public Iterator<GetIpamAddressHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamAddressHistoryRecord> historyRecords() {
        Function<GetIpamAddressHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.historyRecords() != null) {
                return response.historyRecords().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetIpamAddressHistoryResponseFetcher
    implements SyncPageFetcher<GetIpamAddressHistoryResponse> {
        private GetIpamAddressHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamAddressHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIpamAddressHistoryResponse nextPage(GetIpamAddressHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetIpamAddressHistoryIterable.this.client.getIpamAddressHistory(GetIpamAddressHistoryIterable.this.firstRequest);
            }
            return GetIpamAddressHistoryIterable.this.client.getIpamAddressHistory((GetIpamAddressHistoryRequest)((Object)GetIpamAddressHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

