/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.bulk.handler;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.handler.HandlerResult;
import org.elasticsearch.hadoop.rest.bulk.handler.DelayableErrorCollector;

public class BulkWriteErrorCollector
implements DelayableErrorCollector<byte[]> {
    private long delayTimeInMillis = 0L;
    private boolean isRetry = false;
    private byte[] currentRetry = null;
    private String currentMessage = null;

    @Override
    public HandlerResult retry() {
        this.isRetry = true;
        return HandlerResult.HANDLED;
    }

    @Override
    public HandlerResult backoffAndRetry(long timeAmount, TimeUnit timeUnits) {
        long givenDelayTimeInMillis = timeUnits.toMillis(timeAmount);
        if (givenDelayTimeInMillis > this.delayTimeInMillis) {
            this.delayTimeInMillis = givenDelayTimeInMillis;
        }
        return this.retry();
    }

    @Override
    public HandlerResult retry(byte[] retryData) {
        this.currentRetry = retryData;
        return this.retry();
    }

    @Override
    public HandlerResult backoffAndRetry(byte[] retryData, long timeAmount, TimeUnit timeUnits) {
        long givenDelayTimeInMillis = timeUnits.toMillis(timeAmount);
        if (givenDelayTimeInMillis > this.delayTimeInMillis) {
            this.delayTimeInMillis = givenDelayTimeInMillis;
        }
        return this.retry(retryData);
    }

    @Override
    public HandlerResult pass(String reason) {
        if (this.currentMessage != null) {
            throw new EsHadoopIllegalStateException("Error Handler is attempting to pass with a reason, but a reason already exists! Be sure to return the result of your call to errorCollector.pass(String), and call it only once per call to your Handler!");
        }
        this.currentMessage = reason;
        return HandlerResult.PASS;
    }

    public boolean receivedRetries() {
        return this.isRetry;
    }

    public byte[] getAndClearRetryValue() {
        if (this.isRetry) {
            byte[] data = null;
            if (this.currentRetry != null) {
                data = this.currentRetry;
                this.currentRetry = null;
            }
            this.isRetry = false;
            return data;
        }
        return null;
    }

    public String getAndClearMessage() {
        String msg = this.currentMessage;
        this.currentMessage = null;
        return msg;
    }

    public long getDelayTimeBetweenRetries() {
        return this.delayTimeInMillis;
    }
}

