/**
 * MIT License
 *
 * Copyright (c) 2020-present, Elastic NV
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
import SonicBoom from 'sonic-boom';
import { Reporter, ReporterOptions } from '.';
import { Journey, Step } from '../dsl';
import { JourneyEndResult, JourneyStartResult, StepResult } from '../common_types';
export declare function renderDuration(durationMs: any): number;
export default class BaseReporter implements Reporter {
    stream: SonicBoom;
    fd: number;
    dryRun: boolean;
    metrics: {
        succeeded: number;
        failed: number;
        skipped: number;
        registered: number;
    };
    constructor(options?: ReporterOptions);
    onJourneyRegister(journey: Journey): void;
    onJourneyStart(journey: Journey, {}: JourneyStartResult): void;
    onStepEnd(_: Journey, step: Step, {}: StepResult): void;
    onJourneyEnd(journey: Journey, {}: JourneyEndResult): void;
    onEnd(): void;
    write(message: any): void;
}
//# sourceMappingURL=base.d.ts.map