/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Object;

public class Certificate
extends X509Object {
    public final X509AuxCertificate cert;

    public Certificate(X509AuxCertificate cert2) {
        this.cert = cert2;
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    public boolean isName(Name name2) {
        return name2.equalToCertificateSubject(this.cert);
    }

    @Override
    public boolean matches(X509Object other) {
        if (other instanceof Certificate) {
            Certificate that = (Certificate)other;
            if (X509AuxCertificate.equalSubjects(this.cert, that.cert)) {
                return this.cert.hashCode() == that.cert.hashCode();
            }
        }
        return false;
    }

    @Override
    public int compareTo(X509Object other) {
        int cmp2 = super.compareTo(other);
        if (cmp2 != 0) {
            return cmp2;
        }
        return this.cert.equals(((Certificate)other).cert) ? 0 : -1;
    }
}

