/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.geo.XYPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.ShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianShapeValuesSourceType;

public abstract class CartesianShapeValues
extends ShapeValues<CartesianShapeValue> {
    public static final CartesianShapeValues EMPTY = new CartesianShapeValues(){
        private final CartesianShapeValuesSourceType DEFAULT_VALUES_SOURCE_TYPE = CartesianShapeValuesSourceType.instance();

        @Override
        public boolean advanceExact(int doc) {
            return false;
        }

        @Override
        public ValuesSourceType valuesSourceType() {
            return this.DEFAULT_VALUES_SOURCE_TYPE;
        }

        @Override
        public CartesianShapeValue value() {
            throw new UnsupportedOperationException();
        }
    };

    protected CartesianShapeValues() {
        super(CoordinateEncoder.CARTESIAN, CartesianShapeValue::new, new CartesianShapeIndexer("missing"));
    }

    @Override
    public GeometryValidator geometryValidator() {
        return StandardValidator.instance(true);
    }

    public static class CartesianShapeValue
    extends ShapeValues.ShapeValue {
        public CartesianShapeValue() {
            super(CoordinateEncoder.CARTESIAN, CartesianPoint::new);
        }

        public CartesianShapeValue(StreamInput in) throws IOException {
            this();
            this.reset(in);
        }

        @Override
        protected Component2D centroidAsComponent2D() throws IOException {
            return XYGeometry.create(new XYPoint((float)this.getX(), (float)this.getY()));
        }

        public GeoRelation relate(XYGeometry geometry) throws IOException {
            return this.relate(XYGeometry.create(geometry));
        }

        @Override
        public String getWriteableName() {
            return "CartesianShapeValue";
        }
    }
}

