/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.ActiveDirectorySessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapUserSearchSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapMetadataResolverSettings;
import org.elasticsearch.xpack.core.security.authc.support.CachingUsernamePasswordRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.security.authc.support.mapper.CompositeRoleMapperSettings;

public final class LdapRealmSettings {
    public static final String LDAP_TYPE = "ldap";
    public static final String AD_TYPE = "active_directory";
    public static final String TIMEOUT_EXECUTION_SUFFIX = "timeout.execution";
    public static final Function<String, Setting.AffixSetting<TimeValue>> EXECUTION_TIMEOUT = type -> Setting.affixKeySetting(RealmSettings.realmSettingPrefix(type), TIMEOUT_EXECUTION_SUFFIX, key -> Setting.timeSetting(key, TimeValue.timeValueSeconds(30L), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);

    private LdapRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings(String type) {
        HashSet settings = new HashSet();
        settings.addAll(CachingUsernamePasswordRealmSettings.getSettings(type));
        settings.addAll(CompositeRoleMapperSettings.getSettings(type));
        settings.add(EXECUTION_TIMEOUT.apply(type));
        if (AD_TYPE.equals(type)) {
            settings.addAll(ActiveDirectorySessionFactorySettings.getSettings());
        } else {
            assert (LDAP_TYPE.equals(type)) : "type [" + type + "] is unknown. expected one of [active_directory, ldap]";
            settings.addAll(LdapSessionFactorySettings.getSettings());
            settings.addAll(LdapUserSearchSessionFactorySettings.getSettings());
            settings.addAll(DelegatedAuthorizationSettings.getSettings(type));
        }
        settings.addAll(LdapMetadataResolverSettings.getSettings(type));
        settings.addAll(RealmSettings.getStandardSettings(type));
        return settings;
    }
}

