/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class TrainedModelSizeStats
implements ToXContentObject,
Writeable {
    private static final ParseField MODEL_SIZE_BYTES = new ParseField("model_size_bytes", new String[0]);
    private static final ParseField REQUIRED_NATIVE_MEMORY_BYTES = new ParseField("required_native_memory_bytes", new String[0]);
    private final long modelSizeBytes;
    private final long requiredNativeMemoryBytes;

    public TrainedModelSizeStats(long modelSizeBytes, long requiredNativeMemoryBytes) {
        this.modelSizeBytes = modelSizeBytes;
        this.requiredNativeMemoryBytes = requiredNativeMemoryBytes;
    }

    public TrainedModelSizeStats(StreamInput in) throws IOException {
        this.modelSizeBytes = in.readLong();
        this.requiredNativeMemoryBytes = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.modelSizeBytes);
        out.writeLong(this.requiredNativeMemoryBytes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.humanReadableField(MODEL_SIZE_BYTES.getPreferredName(), "model_size", ByteSizeValue.ofBytes(this.modelSizeBytes));
        builder.humanReadableField(REQUIRED_NATIVE_MEMORY_BYTES.getPreferredName(), "required_native_memory", ByteSizeValue.ofBytes(this.requiredNativeMemoryBytes));
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelSizeStats that = (TrainedModelSizeStats)o;
        return this.modelSizeBytes == that.modelSizeBytes && this.requiredNativeMemoryBytes == that.requiredNativeMemoryBytes;
    }

    public int hashCode() {
        return Objects.hash(this.modelSizeBytes, this.requiredNativeMemoryBytes);
    }

    public long getModelSizeBytes() {
        return this.modelSizeBytes;
    }
}

