/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteDataFrameAnalyticsAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteDataFrameAnalyticsAction INSTANCE = new DeleteDataFrameAnalyticsAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/delete";
    public static final String DELETION_TASK_DESCRIPTION_PREFIX = "delete-analytics-";

    private DeleteDataFrameAnalyticsAction() {
        super(NAME);
    }

    public static final class Request
    extends AcknowledgedRequest<Request> {
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        private static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
        private String id;
        private boolean force;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.force = in.readBoolean();
        }

        public Request() {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.ackTimeout(DEFAULT_TIMEOUT);
        }

        public Request(String id) {
            this();
            this.id = ExceptionsHelper.requireNonNull(id, DataFrameAnalyticsConfig.ID);
        }

        public String getId() {
            return this.id;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        @Override
        public String getDescription() {
            return DeleteDataFrameAnalyticsAction.DELETION_TASK_DESCRIPTION_PREFIX + this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.id, request.id) && this.force == request.force && Objects.equals(this.ackTimeout(), request.ackTimeout());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.force);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.force, this.ackTimeout());
        }
    }
}

