/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.InferenceFeatureSetUsage;
import org.elasticsearch.xpack.core.inference.SerializableStats;

public class InferenceRequestStats
implements SerializableStats {
    private final InferenceFeatureSetUsage.ModelStats modelStats;
    private final String modelId;

    public InferenceRequestStats(String service, TaskType taskType, @Nullable String modelId, long count) {
        this(new InferenceFeatureSetUsage.ModelStats(service, taskType, count), modelId);
    }

    private InferenceRequestStats(InferenceFeatureSetUsage.ModelStats modelStats, @Nullable String modelId) {
        this.modelStats = new InferenceFeatureSetUsage.ModelStats(modelStats);
        this.modelId = modelId;
    }

    public InferenceRequestStats(StreamInput in) throws IOException {
        this.modelStats = new InferenceFeatureSetUsage.ModelStats(in);
        this.modelId = in.readOptionalString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("service", this.modelStats.service());
        builder.field("task_type", this.modelStats.taskType().toString());
        builder.field("count", this.modelStats.count());
        if (this.modelId != null) {
            builder.field("model_id", this.modelId);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.modelStats.writeTo(out);
        out.writeOptionalString(this.modelId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceRequestStats that = (InferenceRequestStats)o;
        return Objects.equals(this.modelStats, that.modelStats) && Objects.equals(this.modelId, that.modelId);
    }

    public int hashCode() {
        return Objects.hash(this.modelStats, this.modelId);
    }
}

