/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.metrics.Counters;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class HealthApiFeatureSetUsage
extends XPackFeatureUsage {
    private final Map<String, Object> usageStats;

    public HealthApiFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.usageStats = in.readGenericMap();
    }

    public HealthApiFeatureSetUsage(boolean available, boolean enabled, @Nullable Counters stats) {
        super("health_api", available, enabled);
        if (stats != null) {
            this.usageStats = stats.toMutableNestedMap();
            HealthApiFeatureSetUsage.enrichUsageStatsWithValues(this.usageStats);
        } else {
            this.usageStats = Map.of();
        }
    }

    static void enrichUsageStatsWithValues(Map<String, Object> usageStats) {
        Map statuses;
        if (usageStats.containsKey("statuses") && !(statuses = (Map)usageStats.get("statuses")).isEmpty()) {
            statuses.put("values", statuses.keySet().stream().sorted().collect(Collectors.toList()));
        }
        if (usageStats.containsKey("indicators")) {
            Map indicatorsByStatus = (Map)usageStats.get("indicators");
            for (String status : indicatorsByStatus.keySet()) {
                Map indicators = (Map)indicatorsByStatus.get(status);
                if (indicators.isEmpty()) continue;
                indicators.put("values", indicators.keySet().stream().sorted().collect(Collectors.toList()));
            }
        }
        if (usageStats.containsKey("diagnoses")) {
            Map diagnosesByStatus = (Map)usageStats.get("diagnoses");
            for (String status : diagnosesByStatus.keySet()) {
                Map diagnoses = (Map)diagnosesByStatus.get(status);
                if (diagnoses.isEmpty()) continue;
                diagnoses.put("values", diagnoses.keySet().stream().sorted().collect(Collectors.toList()));
            }
        }
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_7_0;
    }

    public Map<String, Object> stats() {
        return this.usageStats;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        for (Map.Entry<String, Object> entry : this.usageStats.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeGenericMap(this.usageStats);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthApiFeatureSetUsage that = (HealthApiFeatureSetUsage)o;
        return Objects.equals(this.usageStats, that.usageStats);
    }

    public int hashCode() {
        return Objects.hash(this.usageStats);
    }
}

