/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.Bits;

public final class CancellableBulkScorer
extends BulkScorer {
    private static final int INITIAL_INTERVAL = 4096;
    private static final int MAX_INTERVAL = 0x100000;
    private final BulkScorer scorer;
    private final Runnable checkCancelled;

    public CancellableBulkScorer(BulkScorer scorer, Runnable checkCancelled) {
        this.scorer = Objects.requireNonNull(scorer);
        this.checkCancelled = Objects.requireNonNull(checkCancelled);
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int interval = 4096;
        while (min < max) {
            this.checkCancelled.run();
            int newMax = (int)Math.min((long)min + (long)interval, (long)max);
            min = this.scorer.score(collector, acceptDocs, min, newMax);
            interval = Math.min(interval << 1, 0x100000);
        }
        this.checkCancelled.run();
        return min;
    }

    @Override
    public long cost() {
        return this.scorer.cost();
    }
}

