/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.synonyms;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.synonyms.PutSynonymRuleAction;
import org.elasticsearch.action.synonyms.SynonymUpdateResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.synonyms.SynonymCapabilities;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutSynonymRuleAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "synonyms_rule_put_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_synonyms/{synonymsSet}/{synonymRuleId}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PutSynonymRuleAction.Request request = new PutSynonymRuleAction.Request(restRequest.param("synonymsSet"), restRequest.param("synonymRuleId"), restRequest.paramAsBoolean("refresh", true), restRequest.content(), restRequest.getXContentType());
        return channel -> client.execute(PutSynonymRuleAction.INSTANCE, request, new RestToXContentListener<SynonymUpdateResponse>((RestChannel)channel, SynonymUpdateResponse::status, r -> null));
    }

    @Override
    public Set<String> supportedCapabilities() {
        return SynonymCapabilities.CAPABILITIES;
    }
}

