/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.elasticsearch.action.NodeStatsLevel;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.project.ProjectIdResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.xcontent.ToXContent;

@ServerlessScope(value=Scope.INTERNAL)
public class RestNodesStatsAction
extends BaseRestHandler {
    private static final Set<String> SUPPORTED_CAPABILITIES = Set.of("dense_vector_off_heap_stats");
    private final ProjectIdResolver projectIdResolver;
    static final Map<String, Consumer<CommonStatsFlags>> FLAGS;
    private final Set<String> RESPONSE_PARAMS = Collections.singleton("level");

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_nodes/stats"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/stats"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/stats/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/stats/{metric}/{index_metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}/{index_metric}"));
    }

    public RestNodesStatsAction(ProjectIdResolver projectIdResolver) {
        this.projectIdResolver = projectIdResolver;
    }

    @Override
    public String getName() {
        return "nodes_stats_action";
    }

    @Override
    public Set<String> supportedCapabilities() {
        return SUPPORTED_CAPABILITIES;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        Set<String> metricNames = Strings.tokenizeByCommaToSet(request.param("metric", "_all"));
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(nodesIds);
        nodesStatsRequest.setTimeout(RestUtils.getTimeout(request));
        nodesStatsRequest.setIncludeShardsStats(NodeStatsLevel.of(request, NodeStatsLevel.NODE) != NodeStatsLevel.NODE);
        if (metricNames.size() == 1 && metricNames.contains("_all")) {
            if (request.hasParam("index_metric")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains index metrics [%s] but all stats requested", request.path(), request.param("index_metric")));
            }
            nodesStatsRequest.all();
            nodesStatsRequest.indices(CommonStatsFlags.ALL);
        } else {
            if (metricNames.contains("_all")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual metrics [%s]", request.path(), request.param("metric")));
            }
            nodesStatsRequest.clear();
            TreeSet<String> invalidMetrics = new TreeSet<String>();
            for (String metricName : metricNames) {
                if (NodesStatsRequestParameters.Metric.isValid(metricName)) {
                    nodesStatsRequest.addMetric(NodesStatsRequestParameters.Metric.get(metricName));
                    continue;
                }
                if (metricName.equals("indices")) continue;
                invalidMetrics.add(metricName);
            }
            if (!invalidMetrics.isEmpty()) {
                throw new IllegalArgumentException(RestNodesStatsAction.unrecognized(request, invalidMetrics, NodesStatsRequestParameters.Metric.ALL_NAMES, "metric"));
            }
            if (metricNames.contains("indices")) {
                nodesStatsRequest.indices(true);
                Set<String> indexMetrics = Strings.tokenizeByCommaToSet(request.param("index_metric", "_all"));
                if (indexMetrics.size() == 1 && indexMetrics.contains("_all")) {
                    nodesStatsRequest.indices(CommonStatsFlags.ALL);
                } else {
                    CommonStatsFlags flags = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
                    flags.clear();
                    TreeSet<String> invalidIndexMetrics = new TreeSet<String>();
                    for (String indexMetric : indexMetrics) {
                        Consumer<CommonStatsFlags> handler = FLAGS.get(indexMetric);
                        if (handler != null) {
                            handler.accept(flags);
                            continue;
                        }
                        invalidIndexMetrics.add(indexMetric);
                    }
                    if (!invalidIndexMetrics.isEmpty()) {
                        throw new IllegalArgumentException(RestNodesStatsAction.unrecognized(request, invalidIndexMetrics, FLAGS.keySet(), "index metric"));
                    }
                    nodesStatsRequest.indices(flags);
                }
            } else if (request.hasParam("index_metric")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains index metrics [%s] but indices stats not requested", request.path(), request.param("index_metric")));
            }
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.FieldData) && (request.hasParam("fields") || request.hasParam("fielddata_fields"))) {
            nodesStatsRequest.indices().fieldDataFields(request.paramAsStringArray("fielddata_fields", request.paramAsStringArray("fields", null)));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Completion) && (request.hasParam("fields") || request.hasParam("completion_fields"))) {
            nodesStatsRequest.indices().completionDataFields(request.paramAsStringArray("completion_fields", request.paramAsStringArray("fields", null)));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Search) && request.hasParam("groups")) {
            nodesStatsRequest.indices().groups(request.paramAsStringArray("groups", null));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Segments)) {
            nodesStatsRequest.indices().includeSegmentFileSizes(request.paramAsBoolean("include_segment_file_sizes", false));
            nodesStatsRequest.indices().includeUnloadedSegments(request.paramAsBoolean("include_unloaded_segments", false));
        }
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).admin().cluster().nodesStats(nodesStatsRequest, new RestRefCountedChunkedToXContentListener<NodesStatsResponse>((RestChannel)channel, this.xContentParamsForRequest(channel.request())));
    }

    private ToXContent.DelegatingMapParams xContentParamsForRequest(RestRequest request) {
        return new ToXContent.DelegatingMapParams(Map.of("multi_project_enabled_node_stats", Boolean.toString(this.projectIdResolver.supportsMultipleProjects())), request);
    }

    @Override
    protected Set<String> responseParams() {
        return this.RESPONSE_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static {
        HashMap<String, Consumer<CommonStatsFlags>> flags = new HashMap<String, Consumer<CommonStatsFlags>>();
        for (CommonStatsFlags.Flag flag : CommonStatsFlags.Flag.values()) {
            flags.put(flag.getRestName(), f -> f.set(flag, true));
        }
        FLAGS = Collections.unmodifiableMap(flags);
    }
}

