/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateErrorMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.core.Strings;
import org.elasticsearch.reservedstate.service.ErrorState;
import org.elasticsearch.reservedstate.service.ReservedClusterStateService;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;

public class ReservedStateErrorTask
implements ClusterStateTaskListener {
    private static final Logger logger = LogManager.getLogger(ReservedStateErrorTask.class);
    private final ErrorState errorState;
    private final ActionListener<ActionResponse.Empty> listener;

    public ReservedStateErrorTask(ErrorState errorState, ActionListener<ActionResponse.Empty> listener) {
        this.errorState = errorState;
        this.listener = listener;
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    ActionListener<ActionResponse.Empty> listener() {
        return this.listener;
    }

    static boolean isNewError(ReservedStateMetadata existingMetadata, Long newStateVersion, ReservedStateVersionCheck versionCheck) {
        return existingMetadata == null || existingMetadata.errorMetadata() == null || versionCheck.test(existingMetadata.errorMetadata().version(), newStateVersion) || newStateVersion.equals(ReservedStateMetadata.RESTORED_VERSION) || newStateVersion.equals(ReservedStateMetadata.EMPTY_VERSION) || newStateVersion.equals(ReservedStateMetadata.NO_VERSION);
    }

    static ReservedStateMetadata getMetadata(ClusterState state, ErrorState errorState) {
        return (ReservedStateMetadata)errorState.projectId().map(p -> ReservedClusterStateService.getPotentiallyNewProject(state, p).reservedStateMetadata()).orElseGet(() -> state.metadata().reservedStateMetadata()).get(errorState.namespace());
    }

    static boolean checkErrorVersion(ClusterState currentState, ErrorState errorState) {
        ReservedStateMetadata existingMetadata = ReservedStateErrorTask.getMetadata(currentState, errorState);
        if (!ReservedStateErrorTask.isNewError(existingMetadata, errorState.version(), errorState.versionCheck())) {
            logger.info(() -> Strings.format("Not updating error state because version [%s] is less or equal to the last state error version [%s]", errorState.version(), existingMetadata.errorMetadata().version()));
            return false;
        }
        return true;
    }

    boolean shouldUpdate(ClusterState currentState) {
        return ReservedStateErrorTask.checkErrorVersion(currentState, this.errorState);
    }

    ClusterState execute(ClusterState currentState) {
        ClusterState.Builder stateBuilder = new ClusterState.Builder(currentState);
        ReservedStateErrorMetadata errorMetadata = new ReservedStateErrorMetadata(this.errorState.version(), this.errorState.errorKind(), this.errorState.errors());
        if (this.errorState.projectId().isPresent()) {
            ProjectMetadata project = currentState.metadata().getProject(this.errorState.projectId().get());
            ReservedStateMetadata reservedMetadata = project.reservedStateMetadata().get(this.errorState.namespace());
            ReservedStateMetadata.Builder resBuilder = ReservedStateMetadata.builder(this.errorState.namespace(), reservedMetadata);
            resBuilder.errorMetadata(errorMetadata);
            stateBuilder.putProjectMetadata(ProjectMetadata.builder(project).put(resBuilder.build()));
        } else {
            Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
            ReservedStateMetadata reservedMetadata = currentState.metadata().reservedStateMetadata().get(this.errorState.namespace());
            ReservedStateMetadata.Builder resBuilder = ReservedStateMetadata.builder(this.errorState.namespace(), reservedMetadata);
            resBuilder.errorMetadata(errorMetadata);
            metadataBuilder.put(resBuilder.build());
            stateBuilder.metadata(metadataBuilder);
        }
        return stateBuilder.build();
    }
}

