/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.XYEncodingUtils;
import org.elasticsearch.common.geo.GeoUtils;

public abstract class CoordinateEncoder {
    public static final CoordinateEncoder GEO = new GeoShapeCoordinateEncoder();
    public static final CoordinateEncoder CARTESIAN = new CartesianShapeCoordinateEncoder();

    public abstract int encodeX(double var1);

    public abstract int encodeY(double var1);

    public abstract double decodeX(int var1);

    public abstract double decodeY(int var1);

    public abstract double normalizeX(double var1);

    public abstract double normalizeY(double var1);

    private static class GeoShapeCoordinateEncoder
    extends CoordinateEncoder {
        private GeoShapeCoordinateEncoder() {
        }

        @Override
        public int encodeX(double x) {
            if (x == Double.NEGATIVE_INFINITY) {
                return Integer.MIN_VALUE;
            }
            if (x == Double.POSITIVE_INFINITY) {
                return Integer.MAX_VALUE;
            }
            return GeoEncodingUtils.encodeLongitude(x);
        }

        @Override
        public int encodeY(double y) {
            if (y == Double.NEGATIVE_INFINITY) {
                return Integer.MIN_VALUE;
            }
            if (y == Double.POSITIVE_INFINITY) {
                return Integer.MAX_VALUE;
            }
            return GeoEncodingUtils.encodeLatitude(y);
        }

        @Override
        public double decodeX(int x) {
            return GeoEncodingUtils.decodeLongitude(x);
        }

        @Override
        public double decodeY(int y) {
            return GeoEncodingUtils.decodeLatitude(y);
        }

        @Override
        public double normalizeX(double x) {
            return GeoUtils.normalizeLon(x);
        }

        @Override
        public double normalizeY(double y) {
            return GeoUtils.normalizeLat(y);
        }
    }

    private static class CartesianShapeCoordinateEncoder
    extends CoordinateEncoder {
        private CartesianShapeCoordinateEncoder() {
        }

        private int encode(double value) {
            if (value == Double.NEGATIVE_INFINITY) {
                return Integer.MIN_VALUE;
            }
            if (value == Double.POSITIVE_INFINITY) {
                return Integer.MAX_VALUE;
            }
            return XYEncodingUtils.encode((float)value);
        }

        private double decode(int value) {
            if (value == Integer.MIN_VALUE) {
                return Double.NEGATIVE_INFINITY;
            }
            if (value == Integer.MAX_VALUE) {
                return Double.POSITIVE_INFINITY;
            }
            return XYEncodingUtils.decode(value);
        }

        @Override
        public int encodeX(double x) {
            return this.encode(x);
        }

        @Override
        public int encodeY(double y) {
            return this.encode(y);
        }

        @Override
        public double decodeX(int x) {
            return this.decode(x);
        }

        @Override
        public double decodeY(int y) {
            return this.decode(y);
        }

        @Override
        public double normalizeX(double x) {
            return x;
        }

        @Override
        public double normalizeY(double y) {
            return y;
        }
    }
}

