/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexFileNames;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;

public final class LuceneFilesExtensions
extends Enum<LuceneFilesExtensions> {
    public static final /* enum */ LuceneFilesExtensions BFI = new LuceneFilesExtensions("bfi", "BloomFilter Index", false, true);
    public static final /* enum */ LuceneFilesExtensions BFM = new LuceneFilesExtensions("bfm", "BloomFilter Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions CFE = new LuceneFilesExtensions("cfe", "Compound Files Entries", true, false);
    public static final /* enum */ LuceneFilesExtensions CFS = new LuceneFilesExtensions("cfs", "Compound Files", false, true);
    public static final /* enum */ LuceneFilesExtensions CMP = new LuceneFilesExtensions("cmp", "Completion Index", true, false);
    public static final /* enum */ LuceneFilesExtensions DII = new LuceneFilesExtensions("dii", "Points Index", false, false);
    public static final /* enum */ LuceneFilesExtensions DIM = new LuceneFilesExtensions("dim", "Points", false, true);
    public static final /* enum */ LuceneFilesExtensions DOC = new LuceneFilesExtensions("doc", "Frequencies", false, true);
    public static final /* enum */ LuceneFilesExtensions DVD = new LuceneFilesExtensions("dvd", "DocValues", false, true);
    public static final /* enum */ LuceneFilesExtensions DVM = new LuceneFilesExtensions("dvm", "DocValues Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions FDM = new LuceneFilesExtensions("fdm", "Field Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions FDT = new LuceneFilesExtensions("fdt", "Field Data", false, false);
    public static final /* enum */ LuceneFilesExtensions FDX = new LuceneFilesExtensions("fdx", "Field Index", false, false);
    public static final /* enum */ LuceneFilesExtensions FNM = new LuceneFilesExtensions("fnm", "Fields", true, false);
    public static final /* enum */ LuceneFilesExtensions KDD = new LuceneFilesExtensions("kdd", "Points", false, true);
    public static final /* enum */ LuceneFilesExtensions KDI = new LuceneFilesExtensions("kdi", "Points Index", false, true);
    public static final /* enum */ LuceneFilesExtensions KDM = new LuceneFilesExtensions("kdm", "Points Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions LIV = new LuceneFilesExtensions("liv", "Live Documents", false, false);
    public static final /* enum */ LuceneFilesExtensions LKP = new LuceneFilesExtensions("lkp", "Completion Dictionary", false, false);
    public static final /* enum */ LuceneFilesExtensions NVD = new LuceneFilesExtensions("nvd", "Norms", false, true);
    public static final /* enum */ LuceneFilesExtensions NVM = new LuceneFilesExtensions("nvm", "Norms Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions PAY = new LuceneFilesExtensions("pay", "Payloads", false, false);
    public static final /* enum */ LuceneFilesExtensions POS = new LuceneFilesExtensions("pos", "Positions", false, false);
    public static final /* enum */ LuceneFilesExtensions PSM = new LuceneFilesExtensions("psm", "Postings Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions SI = new LuceneFilesExtensions("si", "Segment Info", true, false);
    public static final /* enum */ LuceneFilesExtensions TIM = new LuceneFilesExtensions("tim", "Term Dictionary", false, true);
    public static final /* enum */ LuceneFilesExtensions TIP = new LuceneFilesExtensions("tip", "Term Index", false, true);
    public static final /* enum */ LuceneFilesExtensions TMD = new LuceneFilesExtensions("tmd", "Term Dictionary Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions TMP = new LuceneFilesExtensions("tmp", "Temporary File", false, true);
    public static final /* enum */ LuceneFilesExtensions TVD = new LuceneFilesExtensions("tvd", "Term Vector Documents", false, false);
    public static final /* enum */ LuceneFilesExtensions TVF = new LuceneFilesExtensions("tvf", "Term Vector Fields", false, false);
    public static final /* enum */ LuceneFilesExtensions TVM = new LuceneFilesExtensions("tvm", "Term Vector Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions TVX = new LuceneFilesExtensions("tvx", "Term Vector Index", false, false);
    public static final /* enum */ LuceneFilesExtensions VEC = new LuceneFilesExtensions("vec", "Vector Data", false, true);
    public static final /* enum */ LuceneFilesExtensions VEX = new LuceneFilesExtensions("vex", "Vector Index", false, true);
    public static final /* enum */ LuceneFilesExtensions VEM = new LuceneFilesExtensions("vem", "Vector Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions VEMF = new LuceneFilesExtensions("vemf", "Flat Vector Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions VEMQ = new LuceneFilesExtensions("vemq", "Scalar Quantized Vector Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions VEQ = new LuceneFilesExtensions("veq", "Scalar Quantized Vector Data", false, true);
    public static final /* enum */ LuceneFilesExtensions VEMB = new LuceneFilesExtensions("vemb", "Binarized Vector Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions VEB = new LuceneFilesExtensions("veb", "Binarized Vector Data", false, true);
    public static final /* enum */ LuceneFilesExtensions MIVF = new LuceneFilesExtensions("mivf", "IVF Metadata", true, false);
    public static final /* enum */ LuceneFilesExtensions CENIVF = new LuceneFilesExtensions("cenivf", "IVF Centroid Data", false, true);
    public static final /* enum */ LuceneFilesExtensions CLIVF = new LuceneFilesExtensions("clivf", "IVF Cluster Data", false, true);
    private final String extension;
    private final String description;
    private final boolean mmap;
    private final boolean metadata;
    private static final Map<String, LuceneFilesExtensions> extensions;
    private static final /* synthetic */ LuceneFilesExtensions[] $VALUES;

    public static LuceneFilesExtensions[] values() {
        return (LuceneFilesExtensions[])$VALUES.clone();
    }

    public static LuceneFilesExtensions valueOf(String name) {
        return Enum.valueOf(LuceneFilesExtensions.class, name);
    }

    private static boolean allowUnknownLuceneFileExtensions() {
        return Boolean.parseBoolean(System.getProperty("es.allow_unknown_lucene_file_extensions", "false"));
    }

    private LuceneFilesExtensions(String extension, String description, boolean metadata, boolean mmap) {
        this.description = Objects.requireNonNull(description);
        this.extension = Objects.requireNonNull(extension);
        this.metadata = metadata;
        this.mmap = mmap;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public boolean shouldMmap() {
        return this.mmap;
    }

    @Nullable
    public static LuceneFilesExtensions fromExtension(String ext) {
        if (ext != null && !ext.isEmpty()) {
            LuceneFilesExtensions extension = extensions.get(ext);
            assert (LuceneFilesExtensions.allowUnknownLuceneFileExtensions() || extension != null) : "unknown Lucene file extension [" + ext + "]";
            return extension;
        }
        return null;
    }

    @Nullable
    public static LuceneFilesExtensions fromFile(String fileName) {
        return LuceneFilesExtensions.fromExtension(IndexFileNames.getExtension(fileName));
    }

    private static /* synthetic */ LuceneFilesExtensions[] $values() {
        return new LuceneFilesExtensions[]{BFI, BFM, CFE, CFS, CMP, DII, DIM, DOC, DVD, DVM, FDM, FDT, FDX, FNM, KDD, KDI, KDM, LIV, LKP, NVD, NVM, PAY, POS, PSM, SI, TIM, TIP, TMD, TMP, TVD, TVF, TVM, TVX, VEC, VEX, VEM, VEMF, VEMQ, VEQ, VEMB, VEB, MIVF, CENIVF, CLIVF};
    }

    static {
        $VALUES = LuceneFilesExtensions.$values();
        Map<String, LuceneFilesExtensions> map = Maps.newMapWithExpectedSize(LuceneFilesExtensions.values().length);
        for (LuceneFilesExtensions extension : LuceneFilesExtensions.values()) {
            map.put(extension.extension, extension);
        }
        extensions = Collections.unmodifiableMap(map);
    }
}

