/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.index.reindex.AbstractBulkIndexByScrollRequestBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;

public class UpdateByQueryRequestBuilder
extends AbstractBulkIndexByScrollRequestBuilder<UpdateByQueryRequest, UpdateByQueryRequestBuilder> {
    private Boolean abortOnVersionConflict;
    private String pipeline;

    public UpdateByQueryRequestBuilder(ElasticsearchClient client) {
        this(client, new SearchRequestBuilder(client));
    }

    private UpdateByQueryRequestBuilder(ElasticsearchClient client, SearchRequestBuilder search) {
        super(client, UpdateByQueryAction.INSTANCE, search);
    }

    @Override
    protected UpdateByQueryRequestBuilder self() {
        return this;
    }

    @Override
    public UpdateByQueryRequestBuilder abortOnVersionConflict(boolean abortOnVersionConflict) {
        this.abortOnVersionConflict = abortOnVersionConflict;
        return this;
    }

    public UpdateByQueryRequestBuilder setPipeline(String pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @Override
    public UpdateByQueryRequest request() {
        SearchRequest search = (SearchRequest)this.source().request();
        try {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(search, false);
            try {
                this.apply(updateByQueryRequest);
                return updateByQueryRequest;
            }
            catch (Exception e) {
                updateByQueryRequest.decRef();
                throw e;
            }
        }
        catch (Exception e) {
            search.decRef();
            throw e;
        }
    }

    @Override
    public void apply(UpdateByQueryRequest request) {
        super.apply(request);
        if (this.abortOnVersionConflict != null) {
            request.setAbortOnVersionConflict(this.abortOnVersionConflict);
        }
        if (this.pipeline != null) {
            request.setPipeline(this.pipeline);
        }
    }
}

