/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache;

import java.io.Closeable;
import java.io.IOException;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.cache.query.QueryCache;

public class IndexCache
implements Closeable {
    private final QueryCache queryCache;
    private final BitsetFilterCache bitsetFilterCache;

    public IndexCache(QueryCache queryCache, BitsetFilterCache bitsetFilterCache) {
        this.queryCache = queryCache;
        this.bitsetFilterCache = bitsetFilterCache;
    }

    public QueryCache query() {
        return this.queryCache;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.bitsetFilterCache;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.queryCache, this.bitsetFilterCache);
    }

    public void clear(String reason) {
        this.queryCache.clear(reason);
        this.bitsetFilterCache.clear(reason);
    }
}

