/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.CompositeIndexEventListener;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexingSlowLog;
import org.elasticsearch.index.SearchSlowLog;
import org.elasticsearch.index.SlowLogFieldProvider;
import org.elasticsearch.index.SlowLogFields;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.cache.query.IndexQueryCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.MergeMetrics;
import org.elasticsearch.index.engine.ThreadPoolMergeExecutorService;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.search.stats.SearchStatsSettings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStatsSettings;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.FsDirectoryFactory;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public final class IndexModule {
    private static final Logger logger = LogManager.getLogger(IndexModule.class);
    public static final Setting<Boolean> NODE_STORE_ALLOW_MMAP = Setting.boolSetting("node.store.allow_mmap", true, Setting.Property.NodeScope);
    private static final FsDirectoryFactory DEFAULT_DIRECTORY_FACTORY = new FsDirectoryFactory();
    private static final IndexStorePlugin.RecoveryStateFactory DEFAULT_RECOVERY_STATE_FACTORY = RecoveryState::new;
    public static final Setting<String> INDEX_STORE_TYPE_SETTING = Setting.simpleString("index.store.type", Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<String> INDEX_RECOVERY_TYPE_SETTING = Setting.simpleString("index.recovery.type", Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<List<String>> INDEX_STORE_PRE_LOAD_SETTING = Setting.stringListSetting("index.store.preload", Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final String SIMILARITY_SETTINGS_PREFIX = "index.similarity";
    public static final Setting<Boolean> INDEX_QUERY_CACHE_ENABLED_SETTING = Setting.boolSetting("index.queries.cache.enabled", true, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_EVERYTHING_SETTING = Setting.boolSetting("index.queries.cache.everything", false, Setting.Property.IndexScope);
    private final IndexSettings indexSettings;
    private final AnalysisRegistry analysisRegistry;
    private final EngineFactory engineFactory;
    private final SetOnce<DirectoryWrapper> indexDirectoryWrapper = new SetOnce();
    private final SetOnce<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> indexReaderWrapper = new SetOnce();
    private final Set<IndexEventListener> indexEventListeners = new HashSet<IndexEventListener>();
    private final Map<String, TriFunction<Settings, IndexVersion, ScriptService, Similarity>> similarities = new HashMap<String, TriFunction<Settings, IndexVersion, ScriptService, Similarity>>();
    private final Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories;
    private final SetOnce<BiFunction<IndexSettings, IndicesQueryCache, QueryCache>> forceQueryCacheProvider = new SetOnce();
    private final List<SearchOperationListener> searchOperationListeners;
    private final List<IndexingOperationListener> indexOperationListeners = new ArrayList<IndexingOperationListener>();
    private final IndexNameExpressionResolver expressionResolver;
    private final AtomicBoolean frozen = new AtomicBoolean(false);
    private final BooleanSupplier allowExpensiveQueries;
    private final Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories;
    private final SetOnce<Engine.IndexCommitListener> indexCommitListener = new SetOnce();
    private final MapperMetrics mapperMetrics;
    private final IndexingStatsSettings indexingStatsSettings;
    private final SearchStatsSettings searchStatsSettings;
    private final MergeMetrics mergeMetrics;
    public static final IndexStorePlugin.SnapshotCommitSupplier DEFAULT_SNAPSHOT_COMMIT_SUPPLIER = e -> e.acquireLastIndexCommit(true);

    public IndexModule(IndexSettings indexSettings, AnalysisRegistry analysisRegistry, EngineFactory engineFactory, Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories, BooleanSupplier allowExpensiveQueries, IndexNameExpressionResolver expressionResolver, Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories, SlowLogFieldProvider slowLogFieldProvider, MapperMetrics mapperMetrics, List<SearchOperationListener> searchOperationListeners, IndexingStatsSettings indexingStatsSettings, SearchStatsSettings searchStatsSettings, MergeMetrics mergeMetrics) {
        this.indexSettings = indexSettings;
        this.analysisRegistry = analysisRegistry;
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.searchOperationListeners = new ArrayList<SearchOperationListener>(searchOperationListeners);
        SlowLogFields slowLogFields = slowLogFieldProvider.create(indexSettings);
        this.searchOperationListeners.add(new SearchSlowLog(indexSettings, slowLogFields));
        this.indexOperationListeners.add(new IndexingSlowLog(indexSettings, slowLogFields));
        this.directoryFactories = Collections.unmodifiableMap(directoryFactories);
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.expressionResolver = expressionResolver;
        this.recoveryStateFactories = recoveryStateFactories;
        this.mapperMetrics = mapperMetrics;
        this.indexingStatsSettings = indexingStatsSettings;
        this.searchStatsSettings = searchStatsSettings;
        this.mergeMetrics = mergeMetrics;
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer);
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer, Consumer<T> validator) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer, validator);
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public IndexSettings indexSettings() {
        return this.indexSettings;
    }

    public Index getIndex() {
        return this.indexSettings.getIndex();
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    public void addIndexEventListener(IndexEventListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexEventListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexEventListeners.add(listener);
    }

    public void addSearchOperationListener(SearchOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.searchOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.searchOperationListeners.add(listener);
    }

    public void addIndexOperationListener(IndexingOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexOperationListeners.add(listener);
    }

    public void addSimilarity(String name, TriFunction<Settings, IndexVersion, ScriptService, Similarity> similarity) {
        this.ensureNotFrozen();
        if (this.similarities.containsKey(name) || SimilarityService.BUILT_IN.containsKey(name)) {
            throw new IllegalArgumentException("similarity for name: [" + name + " is already registered");
        }
        this.similarities.put(name, similarity);
    }

    public void setReaderWrapper(Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>> indexReaderWrapperFactory) {
        this.ensureNotFrozen();
        this.indexReaderWrapper.set(indexReaderWrapperFactory);
    }

    public void setDirectoryWrapper(DirectoryWrapper wrapper) {
        this.ensureNotFrozen();
        this.indexDirectoryWrapper.set(Objects.requireNonNull(wrapper));
    }

    public void setIndexCommitListener(Engine.IndexCommitListener listener) {
        this.ensureNotFrozen();
        this.indexCommitListener.set(Objects.requireNonNull(listener));
    }

    IndexEventListener freeze() {
        if (this.frozen.compareAndSet(false, true)) {
            return new CompositeIndexEventListener(this.indexSettings, this.indexEventListeners);
        }
        throw new IllegalStateException("already frozen");
    }

    public static boolean isBuiltinType(String storeType) {
        for (Type type : Type.values()) {
            if (!type.match(storeType)) continue;
            return true;
        }
        return false;
    }

    public static Type defaultStoreType(boolean allowMmap) {
        if (allowMmap && Constants.JRE_IS_64BIT) {
            return Type.HYBRIDFS;
        }
        return Type.NIOFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexService newIndexService(IndexService.IndexCreationContext indexCreationContext, NodeEnvironment environment, XContentParserConfiguration parserConfiguration, IndexService.ShardStoreDeleter shardStoreDeleter, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ThreadPoolMergeExecutorService threadPoolMergeExecutorService, ScriptService scriptService, ClusterService clusterService, Client client, IndicesQueryCache indicesQueryCache, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache, NamedWriteableRegistry namedWriteableRegistry, IdFieldMapper idFieldMapper, ValuesSourceRegistry valuesSourceRegistry, IndexStorePlugin.IndexFoldersDeletionListener indexFoldersDeletionListener, Map<String, IndexStorePlugin.SnapshotCommitSupplier> snapshotCommitSuppliers, QueryRewriteInterceptor queryRewriteInterceptor) throws IOException {
        IndexService indexService;
        block6: {
            IndexEventListener eventListener = this.freeze();
            Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>> readerWrapperFactory = this.indexReaderWrapper.get() == null ? shard -> null : this.indexReaderWrapper.get();
            eventListener.beforeIndexCreated(this.indexSettings.getIndex(), this.indexSettings.getSettings());
            IndexStorePlugin.DirectoryFactory directoryFactory = this.getDirectoryFactory(this.indexSettings, this.directoryFactories);
            IndexStorePlugin.RecoveryStateFactory recoveryStateFactory = IndexModule.getRecoveryStateFactory(this.indexSettings, this.recoveryStateFactories);
            IndexStorePlugin.SnapshotCommitSupplier snapshotCommitSupplier = IndexModule.getSnapshotCommitSupplier(this.indexSettings, snapshotCommitSuppliers);
            QueryCache queryCache = null;
            IndexAnalyzers indexAnalyzers = null;
            boolean success = false;
            try {
                if (this.indexSettings.getValue(INDEX_QUERY_CACHE_ENABLED_SETTING).booleanValue()) {
                    BiFunction<IndexSettings, IndicesQueryCache, QueryCache> queryCacheProvider = this.forceQueryCacheProvider.get();
                    queryCache = queryCacheProvider == null ? new IndexQueryCache(this.indexSettings.getIndex(), indicesQueryCache) : queryCacheProvider.apply(this.indexSettings, indicesQueryCache);
                } else {
                    logger.debug("Using no query cache for [{}]", (Object)this.indexSettings.getIndex());
                    queryCache = DisabledQueryCache.INSTANCE;
                }
                if (IndexService.needsMapperService(this.indexSettings, indexCreationContext)) {
                    indexAnalyzers = this.analysisRegistry.build(indexCreationContext, this.indexSettings);
                }
                IndexService indexService2 = new IndexService(this.indexSettings, indexCreationContext, environment, parserConfiguration, new SimilarityService(this.indexSettings, scriptService, this.similarities), shardStoreDeleter, indexAnalyzers, this.engineFactory, circuitBreakerService, bigArrays, threadPool, threadPoolMergeExecutorService, scriptService, clusterService, client, queryCache, directoryFactory, eventListener, readerWrapperFactory, mapperRegistry, indicesFieldDataCache, this.searchOperationListeners, this.indexOperationListeners, namedWriteableRegistry, idFieldMapper, this.allowExpensiveQueries, this.expressionResolver, valuesSourceRegistry, recoveryStateFactory, indexFoldersDeletionListener, snapshotCommitSupplier, this.indexCommitListener.get(), this.mapperMetrics, queryRewriteInterceptor, this.indexingStatsSettings, this.searchStatsSettings, this.mergeMetrics);
                success = true;
                indexService = indexService2;
                if (success) break block6;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(queryCache, indexAnalyzers);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(queryCache, indexAnalyzers);
        }
        return indexService;
    }

    private IndexStorePlugin.DirectoryFactory getDirectoryFactory(IndexSettings indexSettings, Map<String, IndexStorePlugin.DirectoryFactory> indexStoreFactories) {
        IndexStorePlugin.DirectoryFactory factory;
        String storeType = indexSettings.getValue(INDEX_STORE_TYPE_SETTING);
        Boolean allowMmap = NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings());
        Type type = storeType.isEmpty() || Type.FS.getSettingsKey().equals(storeType) ? IndexModule.defaultStoreType(allowMmap) : (IndexModule.isBuiltinType(storeType) ? Type.fromSettingsKey(storeType) : null);
        if (!(allowMmap.booleanValue() || type != Type.MMAPFS && type != Type.HYBRIDFS)) {
            throw new IllegalArgumentException("store type [" + storeType + "] is not allowed because mmap is disabled");
        }
        if (storeType.isEmpty() || IndexModule.isBuiltinType(storeType)) {
            factory = DEFAULT_DIRECTORY_FACTORY;
        } else {
            factory = indexStoreFactories.get(storeType);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown store type [" + storeType + "]");
            }
        }
        final DirectoryWrapper directoryWrapper = this.indexDirectoryWrapper.get();
        assert (this.frozen.get()) : "IndexModule configuration not frozen";
        if (directoryWrapper != null) {
            return new IndexStorePlugin.DirectoryFactory(){

                @Override
                public Directory newDirectory(IndexSettings indexSettings, ShardPath shardPath) throws IOException {
                    return this.newDirectory(indexSettings, shardPath, null);
                }

                @Override
                public Directory newDirectory(IndexSettings indexSettings, ShardPath shardPath, ShardRouting shardRouting) throws IOException {
                    return directoryWrapper.wrap(factory.newDirectory(indexSettings, shardPath, shardRouting), shardRouting);
                }
            };
        }
        return factory;
    }

    private static IndexStorePlugin.RecoveryStateFactory getRecoveryStateFactory(IndexSettings indexSettings, Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories) {
        String recoveryType = indexSettings.getValue(INDEX_RECOVERY_TYPE_SETTING);
        if (recoveryType.isEmpty()) {
            return DEFAULT_RECOVERY_STATE_FACTORY;
        }
        IndexStorePlugin.RecoveryStateFactory factory = recoveryStateFactories.get(recoveryType);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown recovery type [" + recoveryType + "]");
        }
        return factory;
    }

    private static IndexStorePlugin.SnapshotCommitSupplier getSnapshotCommitSupplier(IndexSettings indexSettings, Map<String, IndexStorePlugin.SnapshotCommitSupplier> snapshotCommitSuppliers) {
        String storeType = indexSettings.getValue(INDEX_STORE_TYPE_SETTING);
        IndexStorePlugin.SnapshotCommitSupplier snapshotCommitSupplier = snapshotCommitSuppliers.get(storeType);
        return snapshotCommitSupplier == null ? DEFAULT_SNAPSHOT_COMMIT_SUPPLIER : snapshotCommitSupplier;
    }

    public MapperService newIndexMapperService(ClusterService clusterService, XContentParserConfiguration parserConfiguration, MapperRegistry mapperRegistry, ScriptService scriptService) throws IOException {
        return new MapperService(clusterService, this.indexSettings, this.analysisRegistry.build(IndexService.IndexCreationContext.METADATA_VERIFICATION, this.indexSettings), parserConfiguration, new SimilarityService(this.indexSettings, scriptService, this.similarities), mapperRegistry, () -> {
            throw new UnsupportedOperationException("no index query shard context available");
        }, this.indexSettings.getMode().idFieldMapperWithoutFieldData(), (ScriptCompiler)scriptService, query -> {
            throw new UnsupportedOperationException("no index query shard context available");
        }, this.mapperMetrics);
    }

    public void forceQueryCacheProvider(BiFunction<IndexSettings, IndicesQueryCache, QueryCache> queryCacheProvider) {
        this.ensureNotFrozen();
        this.forceQueryCacheProvider.set(queryCacheProvider);
    }

    private void ensureNotFrozen() {
        if (this.frozen.get()) {
            throw new IllegalStateException("Can't modify IndexModule once the index service has been created");
        }
    }

    @FunctionalInterface
    public static interface DirectoryWrapper {
        public Directory wrap(Directory var1, @Nullable ShardRouting var2) throws IOException;
    }

    public static enum Type {
        HYBRIDFS("hybridfs"),
        NIOFS("niofs"),
        MMAPFS("mmapfs"),
        SIMPLEFS("simplefs"),
        FS("fs");

        private final String settingsKey;
        private static final Map<String, Type> TYPES;

        private Type(String settingsKey) {
            this.settingsKey = settingsKey;
        }

        public String getSettingsKey() {
            return this.settingsKey;
        }

        public static Type fromSettingsKey(String key) {
            Type type = TYPES.get(key);
            if (type == null) {
                throw new IllegalArgumentException("no matching store type for [" + key + "]");
            }
            return type;
        }

        public boolean match(String setting) {
            return this.getSettingsKey().equals(setting);
        }

        static {
            Map<String, Type> types = Maps.newMapWithExpectedSize(4);
            for (Type type : Type.values()) {
                types.put(type.settingsKey, type);
            }
            TYPES = Collections.unmodifiableMap(types);
        }
    }
}

