/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.node.DataStreamLifecycleHealthInfo;
import org.elasticsearch.health.node.DiskHealthInfo;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.health.node.RepositoriesHealthInfo;
import org.elasticsearch.health.node.selection.HealthNode;
import org.elasticsearch.reservedstate.service.FileSettingsService;

public class HealthInfoCache
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(HealthInfoCache.class);
    private volatile ConcurrentHashMap<String, DiskHealthInfo> diskInfoByNode = new ConcurrentHashMap();
    @Nullable
    private volatile DataStreamLifecycleHealthInfo dslHealthInfo = null;
    private volatile ConcurrentHashMap<String, RepositoriesHealthInfo> repositoriesInfoByNode = new ConcurrentHashMap();
    private volatile FileSettingsService.FileSettingsHealthInfo fileSettingsHealthInfo = FileSettingsService.FileSettingsHealthInfo.INDETERMINATE;

    private HealthInfoCache() {
    }

    public static HealthInfoCache create(ClusterService clusterService) {
        HealthInfoCache healthInfoCache = new HealthInfoCache();
        clusterService.addListener(healthInfoCache);
        return healthInfoCache;
    }

    public void updateNodeHealth(String nodeId, @Nullable DiskHealthInfo diskHealthInfo, @Nullable DataStreamLifecycleHealthInfo latestDslHealthInfo, @Nullable RepositoriesHealthInfo repositoriesHealthInfo, @Nullable FileSettingsService.FileSettingsHealthInfo fileSettingsHealthInfo) {
        if (diskHealthInfo != null) {
            this.diskInfoByNode.put(nodeId, diskHealthInfo);
        }
        if (latestDslHealthInfo != null) {
            this.dslHealthInfo = latestDslHealthInfo;
        }
        if (repositoriesHealthInfo != null) {
            this.repositoriesInfoByNode.put(nodeId, repositoriesHealthInfo);
        }
        if (fileSettingsHealthInfo != null) {
            this.fileSettingsHealthInfo = fileSettingsHealthInfo;
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        DiscoveryNode currentHealthNode = HealthNode.findHealthNode(event.state());
        DiscoveryNode localNode = event.state().nodes().getLocalNode();
        if (currentHealthNode != null && localNode.getId().equals(currentHealthNode.getId())) {
            if (event.nodesRemoved()) {
                for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                    this.diskInfoByNode.remove(removedNode.getId());
                    this.repositoriesInfoByNode.remove(removedNode.getId());
                }
            }
        } else if (!this.diskInfoByNode.isEmpty() || this.dslHealthInfo != null || !this.repositoriesInfoByNode.isEmpty()) {
            logger.debug("Node [{}][{}] is no longer the health node, emptying the cache.", (Object)localNode.getName(), (Object)localNode.getId());
            this.diskInfoByNode = new ConcurrentHashMap();
            this.dslHealthInfo = null;
            this.repositoriesInfoByNode = new ConcurrentHashMap();
            this.fileSettingsHealthInfo = FileSettingsService.FileSettingsHealthInfo.INDETERMINATE;
        }
    }

    public HealthInfo getHealthInfo() {
        return new HealthInfo(Map.copyOf(this.diskInfoByNode), this.dslHealthInfo, Map.copyOf(this.repositoriesInfoByNode), this.fileSettingsHealthInfo);
    }
}

