/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.transport.NoSuchRemoteClusterException;

public final class ClusterNameExpressionResolver {
    public static List<String> resolveClusterNames(Set<String> remoteClusters, String clusterExpression) {
        if (remoteClusters.contains(clusterExpression)) {
            return Collections.singletonList(clusterExpression);
        }
        if (Regex.isSimpleMatchPattern(clusterExpression)) {
            return WildcardExpressionResolver.resolve(remoteClusters, clusterExpression);
        }
        throw new NoSuchRemoteClusterException(clusterExpression);
    }

    private static class WildcardExpressionResolver {
        private WildcardExpressionResolver() {
        }

        private static List<String> resolve(Set<String> remoteClusters, String clusterExpression) {
            if (WildcardExpressionResolver.isTrivialWildcard(clusterExpression)) {
                return WildcardExpressionResolver.resolveTrivialWildcard(remoteClusters);
            }
            Set<String> matches = WildcardExpressionResolver.matches(remoteClusters, clusterExpression);
            if (matches.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(matches);
        }

        private static boolean isTrivialWildcard(String clusterExpression) {
            return Regex.isMatchAllPattern(clusterExpression);
        }

        private static List<String> resolveTrivialWildcard(Set<String> remoteClusters) {
            return new ArrayList<String>(remoteClusters);
        }

        private static Set<String> matches(Set<String> remoteClusters, String expression) {
            return WildcardExpressionResolver.otherWildcard(remoteClusters, expression);
        }

        private static Set<String> otherWildcard(Set<String> remoteClusters, String expression) {
            String pattern = expression;
            return remoteClusters.stream().filter(n -> Regex.simpleMatch(pattern, n)).collect(Collectors.toSet());
        }
    }
}

