/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.geoip;

import co.elastic.logstash.filters.elasticintegration.geoip.IpDatabaseAdapter;
import co.elastic.logstash.filters.elasticintegration.geoip.IpDatabaseHolder;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.IOUtils;

public class ManagedIpDatabaseHolder
implements IpDatabaseHolder,
Closeable {
    private static final Logger LOGGER = LogManager.getLogger();
    private IpDatabaseAdapter currentDatabase;
    private final String databaseTypeIdentifier;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public ManagedIpDatabaseHolder(String databaseTypeIdentifier) {
        this(databaseTypeIdentifier, null);
    }

    ManagedIpDatabaseHolder(String databaseTypeIdentifier, Path databaseLocation) {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.databaseTypeIdentifier = databaseTypeIdentifier;
        if (Objects.nonNull(databaseLocation)) {
            this.setDatabasePath(databaseLocation.toAbsolutePath().toString());
        }
    }

    @Override
    public boolean isValid() {
        return this.withLock((Lock)this.readLock, () -> Objects.nonNull(this.currentDatabase));
    }

    @Override
    public IpDatabaseAdapter getDatabase() {
        return this.withLock((Lock)this.readLock, () -> this.currentDatabase);
    }

    @Override
    public String getTypeIdentifier() {
        return this.databaseTypeIdentifier;
    }

    @Override
    public String info() {
        return this.withLock((Lock)this.readLock, () -> String.format("ManagedIpDatabase{type=%s, valid=%s}", this.getTypeIdentifier(), this.isValid()));
    }

    public void setDatabasePath(String newDatabasePath) {
        IpDatabaseAdapter previousDatabase = this.withLock((Lock)this.writeLock, () -> {
            IpDatabaseAdapter localPreviousDatabase = this.currentDatabase;
            this.currentDatabase = Optional.ofNullable(newDatabasePath).map(x$0 -> Paths.get(x$0, new String[0])).map(this::loadDatabase).orElse(null);
            return localPreviousDatabase;
        });
        if (previousDatabase != null) {
            IOUtils.closeWhileHandlingException(previousDatabase::closeReader);
        }
    }

    @Override
    public void close() throws IOException {
        this.withLock((Lock)this.writeLock, () -> {
            if (Objects.nonNull(this.currentDatabase)) {
                try {
                    this.currentDatabase.closeReader();
                }
                catch (IOException e) {
                    this.currentDatabase = null;
                    throw new RuntimeException(e);
                }
                this.currentDatabase = null;
            }
        });
    }

    private IpDatabaseAdapter loadDatabase(Path databasePath) {
        try {
            IpDatabaseAdapter candidate = IpDatabaseAdapter.defaultForPath(databasePath);
            String candidateType = candidate.getDatabaseType();
            if (!Objects.equals(candidateType, this.databaseTypeIdentifier)) {
                throw new IllegalStateException(String.format("Incompatible database type `%s` (expected `%s`)", candidateType, this.databaseTypeIdentifier));
            }
            return candidate;
        }
        catch (IOException e) {
            LOGGER.warn(() -> String.format("failed to load database from path `%s`: %s", databasePath, e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(Lock lock, Supplier<T> handler) {
        lock.lock();
        try {
            T t = handler.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private void withLock(Lock lock, Runnable runnable) {
        this.withLock(lock, () -> {
            runnable.run();
            return null;
        });
    }
}

