/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransformHealthIssue
implements JsonpSerializable {
    private final String type;
    private final String issue;
    @Nullable
    private final String details;
    private final int count;
    @Nullable
    private final Long firstOccurrence;
    @Nullable
    private final DateTime firstOccurenceString;
    public static final JsonpDeserializer<TransformHealthIssue> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformHealthIssue::setupTransformHealthIssueDeserializer);

    private TransformHealthIssue(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.issue = ApiTypeHelper.requireNonNull(builder.issue, this, "issue");
        this.details = builder.details;
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.firstOccurrence = builder.firstOccurrence;
        this.firstOccurenceString = builder.firstOccurenceString;
    }

    public static TransformHealthIssue of(Function<Builder, ObjectBuilder<TransformHealthIssue>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String type() {
        return this.type;
    }

    public final String issue() {
        return this.issue;
    }

    @Nullable
    public final String details() {
        return this.details;
    }

    public final int count() {
        return this.count;
    }

    @Nullable
    public final Long firstOccurrence() {
        return this.firstOccurrence;
    }

    @Nullable
    public final DateTime firstOccurenceString() {
        return this.firstOccurenceString;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("issue");
        generator.write(this.issue);
        if (this.details != null) {
            generator.writeKey("details");
            generator.write(this.details);
        }
        generator.writeKey("count");
        generator.write(this.count);
        if (this.firstOccurrence != null) {
            generator.writeKey("first_occurrence");
            generator.write(this.firstOccurrence);
        }
        if (this.firstOccurenceString != null) {
            generator.writeKey("first_occurence_string");
            this.firstOccurenceString.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTransformHealthIssueDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::issue, JsonpDeserializer.stringDeserializer(), "issue");
        op.add(Builder::details, JsonpDeserializer.stringDeserializer(), "details");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::firstOccurrence, JsonpDeserializer.longDeserializer(), "first_occurrence");
        op.add(Builder::firstOccurenceString, DateTime._DESERIALIZER, "first_occurence_string");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformHealthIssue> {
        private String type;
        private String issue;
        @Nullable
        private String details;
        private Integer count;
        @Nullable
        private Long firstOccurrence;
        @Nullable
        private DateTime firstOccurenceString;

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder issue(String value) {
            this.issue = value;
            return this;
        }

        public final Builder details(@Nullable String value) {
            this.details = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder firstOccurrence(@Nullable Long value) {
            this.firstOccurrence = value;
            return this;
        }

        public final Builder firstOccurenceString(@Nullable DateTime value) {
            this.firstOccurenceString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformHealthIssue build() {
            this._checkSingleUse();
            return new TransformHealthIssue(this);
        }
    }
}

