/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.SettingsSimilarity;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SettingsSimilarityBm25
implements SettingsSimilarityVariant,
JsonpSerializable {
    @Nullable
    private final Double b;
    @Nullable
    private final Boolean discountOverlaps;
    @Nullable
    private final Double k1;
    public static final JsonpDeserializer<SettingsSimilarityBm25> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SettingsSimilarityBm25::setupSettingsSimilarityBm25Deserializer);

    private SettingsSimilarityBm25(Builder builder) {
        this.b = builder.b;
        this.discountOverlaps = builder.discountOverlaps;
        this.k1 = builder.k1;
    }

    public static SettingsSimilarityBm25 of(Function<Builder, ObjectBuilder<SettingsSimilarityBm25>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SettingsSimilarity.Kind _settingsSimilarityKind() {
        return SettingsSimilarity.Kind.Bm25;
    }

    @Nullable
    public final Double b() {
        return this.b;
    }

    @Nullable
    public final Boolean discountOverlaps() {
        return this.discountOverlaps;
    }

    @Nullable
    public final Double k1() {
        return this.k1;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "BM25");
        if (this.b != null) {
            generator.writeKey("b");
            generator.write(this.b);
        }
        if (this.discountOverlaps != null) {
            generator.writeKey("discount_overlaps");
            generator.write(this.discountOverlaps);
        }
        if (this.k1 != null) {
            generator.writeKey("k1");
            generator.write(this.k1);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSettingsSimilarityBm25Deserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::b, JsonpDeserializer.doubleDeserializer(), "b");
        op.add(Builder::discountOverlaps, JsonpDeserializer.booleanDeserializer(), "discount_overlaps");
        op.add(Builder::k1, JsonpDeserializer.doubleDeserializer(), "k1");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SettingsSimilarityBm25> {
        @Nullable
        private Double b;
        @Nullable
        private Boolean discountOverlaps;
        @Nullable
        private Double k1;

        public final Builder b(@Nullable Double value) {
            this.b = value;
            return this;
        }

        public final Builder discountOverlaps(@Nullable Boolean value) {
            this.discountOverlaps = value;
            return this;
        }

        public final Builder k1(@Nullable Double value) {
            this.k1 = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SettingsSimilarityBm25 build() {
            this._checkSingleUse();
            return new SettingsSimilarityBm25(this);
        }
    }
}

