/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExtendedStatsBucketAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final Double sigma;
    public static final JsonpDeserializer<ExtendedStatsBucketAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedStatsBucketAggregation::setupExtendedStatsBucketAggregationDeserializer);

    private ExtendedStatsBucketAggregation(Builder builder) {
        super(builder);
        this.sigma = builder.sigma;
    }

    public static ExtendedStatsBucketAggregation of(Function<Builder, ObjectBuilder<ExtendedStatsBucketAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.ExtendedStatsBucket;
    }

    @Nullable
    public final Double sigma() {
        return this.sigma;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.sigma != null) {
            generator.writeKey("sigma");
            generator.write(this.sigma);
        }
    }

    protected static void setupExtendedStatsBucketAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::sigma, JsonpDeserializer.doubleDeserializer(), "sigma");
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExtendedStatsBucketAggregation> {
        @Nullable
        private Double sigma;

        public final Builder sigma(@Nullable Double value) {
            this.sigma = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExtendedStatsBucketAggregation build() {
            this._checkSingleUse();
            return new ExtendedStatsBucketAggregation(this);
        }
    }
}

