/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.QueueFactoryExt;
import org.logstash.ackedqueue.ext.JRubyAckedQueueExt;
import org.logstash.ackedqueue.ext.JRubyWrappedAckedQueueExt;
import org.logstash.common.DeadLetterQueueFactory;
import org.logstash.common.EnvironmentVariableProvider;
import org.logstash.common.IncompleteSourceWithMetadataException;
import org.logstash.common.SourceWithMetadata;
import org.logstash.common.io.DeadLetterQueueWriter;
import org.logstash.common.io.QueueStorageType;
import org.logstash.config.ir.CompiledPipeline;
import org.logstash.config.ir.ConfigCompiler;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.PipelineConfig;
import org.logstash.config.ir.PipelineIR;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.ConditionalEvaluationError;
import org.logstash.execution.AbstractWrappedQueueExt;
import org.logstash.execution.PipelineReporterExt;
import org.logstash.execution.QueueReadClientBase;
import org.logstash.execution.queue.QueueWriter;
import org.logstash.ext.JRubyAbstractQueueWriteClientExt;
import org.logstash.ext.JRubyWrappedWriteClientExt;
import org.logstash.health.PipelineIndicator;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.FlowMetric;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.MetricType;
import org.logstash.instrument.metrics.NullMetricExt;
import org.logstash.instrument.metrics.UpScaledMetric;
import org.logstash.instrument.metrics.UptimeMetric;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.metrics.gauge.LazyDelegatingGauge;
import org.logstash.instrument.metrics.gauge.NumberGauge;
import org.logstash.instrument.metrics.timer.TimerMetric;
import org.logstash.plugins.ConfigVariableExpander;
import org.logstash.plugins.factory.ExecutionContextFactoryExt;
import org.logstash.plugins.factory.PluginFactoryExt;
import org.logstash.plugins.factory.PluginMetricsFactoryExt;
import org.logstash.secret.store.SecretStore;
import org.logstash.secret.store.SecretStoreExt;

@JRubyClass(name={"AbstractPipeline"})
public class AbstractPipelineExt
extends RubyBasicObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(AbstractPipelineExt.class);
    private static final RubyArray CAPACITY_NAMESPACE = RubyArray.newArray((Ruby)RubyUtil.RUBY, (IRubyObject)MetricKeys.CAPACITY_KEY);
    private static final RubyArray DATA_NAMESPACE = RubyArray.newArray((Ruby)RubyUtil.RUBY, (IRubyObject)RubyUtil.RUBY.newSymbol("data"));
    private static final RubyArray EVENTS_METRIC_NAMESPACE = RubyArray.newArray((Ruby)RubyUtil.RUBY, (IRubyObject[])new IRubyObject[]{MetricKeys.STATS_KEY, MetricKeys.EVENTS_KEY});
    protected PipelineIR lir;
    private transient CompiledPipeline lirExecution;
    private final RubyString ephemeralId = RubyUtil.RUBY.newString(UUID.randomUUID().toString());
    private AbstractNamespacedMetricExt dlqMetric;
    private RubyString configString;
    private List<SourceWithMetadata> configParts;
    private transient IRubyObject settings;
    private transient IRubyObject pipelineSettings;
    private transient IRubyObject pipelineId;
    private transient AbstractMetricExt metric;
    private transient IRubyObject dlqWriter;
    private PipelineReporterExt reporter;
    private AbstractWrappedQueueExt queue;
    private JRubyAbstractQueueWriteClientExt inputQueueClient;
    private QueueReadClientBase filterQueueClient;
    private final transient ScopedFlowMetrics scopedFlowMetrics = new ScopedFlowMetrics();
    private RubyArray inputs;
    private RubyArray filters;
    private RubyArray outputs;
    private String lastErrorEvaluationReceived = "";
    private transient DeadLetterQueueWriter javaDlqWriter;

    public AbstractPipelineExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=4)
    public AbstractPipelineExt initialize(ThreadContext context, IRubyObject[] args) throws IncompleteSourceWithMetadataException, NoSuchAlgorithmException {
        this.initialize(context, args[0], args[1], args[2]);
        this.lirExecution = new CompiledPipeline(this.lir, new PluginFactoryExt(context.runtime, RubyUtil.PLUGIN_FACTORY_CLASS).init(this.lir, new PluginMetricsFactoryExt(context.runtime, RubyUtil.PLUGIN_METRICS_FACTORY_CLASS).initialize(context, this.pipelineId(), (IRubyObject)this.metric()), new ExecutionContextFactoryExt(context.runtime, RubyUtil.EXECUTION_CONTEXT_FACTORY_CLASS).initialize(context, args[3], (IRubyObject)this, this.dlqWriter(context)), RubyUtil.FILTER_DELEGATOR_CLASS), this.getSecretStore(context), new LogErrorEvaluationListener());
        this.inputs = RubyArray.newArray((Ruby)context.runtime, this.lirExecution.inputs());
        this.filters = RubyArray.newArray((Ruby)context.runtime, this.lirExecution.filters());
        this.outputs = RubyArray.newArray((Ruby)context.runtime, this.lirExecution.outputs());
        if (this.getSetting(context, "config.debug").isTrue() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compiled pipeline code for pipeline {} : {}", (Object)this.pipelineId(), (Object)this.lir.getGraph().toString());
        }
        return this;
    }

    @JRubyMethod
    private AbstractPipelineExt initialize(ThreadContext context, IRubyObject pipelineConfig, IRubyObject namespacedMetric, IRubyObject rubyLogger) throws NoSuchAlgorithmException {
        this.reporter = new PipelineReporterExt(context.runtime, RubyUtil.PIPELINE_REPORTER_CLASS).initialize(context, rubyLogger, (IRubyObject)this);
        this.pipelineSettings = pipelineConfig;
        this.configString = (RubyString)this.pipelineSettings.callMethod(context, "config_string");
        this.configParts = ((PipelineConfig)this.pipelineSettings.toJava(PipelineConfig.class)).getConfigParts();
        this.settings = this.pipelineSettings.callMethod(context, "settings");
        IRubyObject id = this.getSetting(context, "pipeline.id");
        this.pipelineId = id.isNil() ? this.id() : id;
        if (namespacedMetric.isNil()) {
            this.metric = new NullMetricExt(context.runtime, RubyUtil.NULL_METRIC_CLASS).initialize(context, new IRubyObject[0]);
        } else {
            AbstractMetricExt java = (AbstractMetricExt)namespacedMetric;
            this.metric = this.getSetting(context, "metric.collect").isTrue() ? java : new NullMetricExt(context.runtime, RubyUtil.NULL_METRIC_CLASS).initialize(context, new IRubyObject[]{java.collector(context)});
        }
        boolean supportEscapes = this.getSetting(context, "config.support_escapes").isTrue();
        try (ConfigVariableExpander cve = new ConfigVariableExpander(this.getSecretStore(context), EnvironmentVariableProvider.defaultProvider());){
            this.lir = ConfigCompiler.configToPipelineIR(this.configParts, supportEscapes, cve);
        }
        catch (InvalidIRException iirex) {
            throw new IllegalArgumentException(iirex);
        }
        return this;
    }

    @JRubyMethod(name={"open_queue"})
    public final IRubyObject openQueue(ThreadContext context) {
        try {
            this.queue = QueueFactoryExt.create(context, null, this.settings);
        }
        catch (Exception ex) {
            LOGGER.error("Logstash failed to create queue.", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        this.inputQueueClient = this.queue.writeClient(context);
        this.filterQueueClient = this.queue.readClient();
        this.filterQueueClient.setEventsMetric((IRubyObject)this.metric.namespace(context, (IRubyObject)EVENTS_METRIC_NAMESPACE));
        this.filterQueueClient.setPipelineMetric((IRubyObject)this.metric.namespace(context, (IRubyObject)RubyArray.newArray((Ruby)context.runtime, (IRubyObject[])new IRubyObject[]{MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, this.pipelineId.convertToString().intern(), MetricKeys.EVENTS_KEY})));
        return context.nil;
    }

    @JRubyMethod(name={"process_events_namespace_metric"})
    public final IRubyObject processEventsNamespaceMetric(ThreadContext context) {
        return this.metric.namespace(context, (IRubyObject)EVENTS_METRIC_NAMESPACE);
    }

    @JRubyMethod(name={"pipeline_events_namespace_metric"})
    public final IRubyObject pipelineEventsNamespaceMetric(ThreadContext context) {
        return this.metric.namespace(context, (IRubyObject)this.pipelineNamespacedPath(MetricKeys.EVENTS_KEY));
    }

    @JRubyMethod(name={"filter_queue_client"})
    public final QueueReadClientBase filterQueueClient() {
        return this.filterQueueClient;
    }

    @JRubyMethod(name={"config_str"})
    public final RubyString configStr() {
        return this.configString;
    }

    @JRubyMethod(name={"ephemeral_id"})
    public final RubyString ephemeralId() {
        return this.ephemeralId;
    }

    @JRubyMethod
    public final IRubyObject settings() {
        return this.settings;
    }

    @JRubyMethod(name={"pipeline_config"})
    public final IRubyObject pipelineConfig() {
        return this.pipelineSettings;
    }

    @JRubyMethod(name={"pipeline_id"})
    public final IRubyObject pipelineId() {
        return this.pipelineId;
    }

    @JRubyMethod
    public final AbstractMetricExt metric() {
        return this.metric;
    }

    @JRubyMethod
    public final IRubyObject lir(ThreadContext context) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)this.lir);
    }

    @JRubyMethod(name={"lir_execution"})
    public IRubyObject lirExecution(ThreadContext context) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)this.lirExecution);
    }

    @JRubyMethod(name={"dlq_writer"})
    public final IRubyObject dlqWriter(ThreadContext context) {
        if (this.dlqWriter == null) {
            if (this.dlqEnabled(context).isTrue()) {
                this.javaDlqWriter = this.createDeadLetterQueueWriterFromSettings(context);
                this.dlqWriter = JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)this.javaDlqWriter);
            } else {
                this.dlqWriter = RubyUtil.DUMMY_DLQ_WRITER_CLASS.callMethod(context, "new");
            }
        }
        return this.dlqWriter;
    }

    private DeadLetterQueueWriter createDeadLetterQueueWriterFromSettings(ThreadContext context) {
        QueueStorageType storageType = QueueStorageType.parse(this.getSetting(context, "dead_letter_queue.storage_policy").asJavaString());
        String dlqPath = this.getSetting(context, "path.dead_letter_queue").asJavaString();
        long dlqMaxBytes = this.getSetting(context, "dead_letter_queue.max_bytes").convertToInteger().getLongValue();
        Duration dlqFlushInterval = Duration.ofMillis(this.getSetting(context, "dead_letter_queue.flush_interval").convertToInteger().getLongValue());
        if (this.hasSetting(context, "dead_letter_queue.retain.age") && !this.getSetting(context, "dead_letter_queue.retain.age").isNil()) {
            Duration age = AbstractPipelineExt.parseToDuration(this.getSetting(context, "dead_letter_queue.retain.age").convertToString().toString());
            return DeadLetterQueueFactory.getWriter(this.pipelineId.asJavaString(), dlqPath, dlqMaxBytes, dlqFlushInterval, storageType, age);
        }
        return DeadLetterQueueFactory.getWriter(this.pipelineId.asJavaString(), dlqPath, dlqMaxBytes, dlqFlushInterval, storageType);
    }

    @VisibleForTesting
    static Duration parseToDuration(String timeStr) {
        ChronoUnit unit;
        String timeSpecifier;
        Matcher matcher = Pattern.compile("(?<value>\\d+)\\s*(?<time>[dhms])").matcher(timeStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Expected a time specification in the form <number>[d,h,m,s], e.g. 3m, but found [" + timeStr + "]");
        }
        int value = Integer.parseInt(matcher.group("value"));
        switch (timeSpecifier = matcher.group("time")) {
            case "d": {
                unit = ChronoUnit.DAYS;
                break;
            }
            case "h": {
                unit = ChronoUnit.HOURS;
                break;
            }
            case "m": {
                unit = ChronoUnit.MINUTES;
                break;
            }
            case "s": {
                unit = ChronoUnit.SECONDS;
                break;
            }
            default: {
                throw new IllegalStateException("Expected a time unit specification from d,h,m,s but found: [" + timeSpecifier + "]");
            }
        }
        return Duration.of(value, unit);
    }

    @JRubyMethod(name={"dlq_enabled?"})
    public final IRubyObject dlqEnabled(ThreadContext context) {
        return this.getSetting(context, "dead_letter_queue.enable");
    }

    @JRubyMethod(name={"close_dlq_writer"})
    public final IRubyObject closeDlqWriter(ThreadContext context) {
        this.dlqWriter.callMethod(context, "close");
        if (this.dlqEnabled(context).isTrue()) {
            DeadLetterQueueFactory.release(this.pipelineId.asJavaString());
        }
        return context.nil;
    }

    @JRubyMethod
    public final PipelineReporterExt reporter() {
        return this.reporter;
    }

    @JRubyMethod(name={"collect_dlq_stats"})
    public final IRubyObject collectDlqStats(ThreadContext context) {
        if (this.dlqEnabled(context).isTrue()) {
            this.getDlqMetric(context).gauge(context, (IRubyObject)MetricKeys.QUEUE_SIZE_IN_BYTES_KEY, this.dlqWriter(context).callMethod(context, "get_current_queue_size"));
            this.getDlqMetric(context).gauge(context, (IRubyObject)MetricKeys.STORAGE_POLICY_KEY, this.dlqWriter(context).callMethod(context, "get_storage_policy"));
            this.getDlqMetric(context).gauge(context, (IRubyObject)MetricKeys.MAX_QUEUE_SIZE_IN_BYTES_KEY, (IRubyObject)this.getSetting(context, "dead_letter_queue.max_bytes").convertToInteger());
            this.getDlqMetric(context).gauge(context, (IRubyObject)MetricKeys.DROPPED_EVENTS_KEY, this.dlqWriter(context).callMethod(context, "get_dropped_events"));
            this.getDlqMetric(context).gauge(context, (IRubyObject)MetricKeys.LAST_ERROR_KEY, this.dlqWriter(context).callMethod(context, "get_last_error"));
            this.getDlqMetric(context).gauge(context, (IRubyObject)MetricKeys.EXPIRED_EVENTS_KEY, this.dlqWriter(context).callMethod(context, "get_expired_events"));
        }
        return context.nil;
    }

    @JRubyMethod(name={"system?"})
    public final IRubyObject isSystem(ThreadContext context) {
        return this.getSetting(context, "pipeline.system");
    }

    @JRubyMethod(name={"configured_as_reloadable?"})
    public final IRubyObject isConfiguredReloadable(ThreadContext context) {
        return this.getSetting(context, "pipeline.reloadable");
    }

    @JRubyMethod(name={"reloadable?"})
    public RubyBoolean isReloadable(ThreadContext context) {
        return this.isConfiguredReloadable(context).isTrue() && this.reloadablePlugins(context).isTrue() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"reloadable_plugins?"})
    public RubyBoolean reloadablePlugins(ThreadContext context) {
        return this.nonReloadablePlugins(context).isEmpty() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"non_reloadable_plugins"})
    public RubyArray nonReloadablePlugins(ThreadContext context) {
        RubyArray result = RubyArray.newArray((Ruby)context.runtime);
        Stream.of(this.inputs, this.outputs, this.filters).flatMap(plugins -> plugins.stream()).filter(plugin -> !plugin.callMethod(context, "reloadable?").isTrue()).forEach(arg_0 -> ((RubyArray)result).add(arg_0));
        return result;
    }

    @JRubyMethod(name={"collect_stats"})
    public final IRubyObject collectStats(ThreadContext context) throws IOException {
        AbstractNamespacedMetricExt pipelineMetric = this.metric.namespace(context, (IRubyObject)this.pipelineNamespacedPath(MetricKeys.QUEUE_KEY));
        pipelineMetric.gauge(context, (IRubyObject)MetricKeys.TYPE_KEY, this.getSetting(context, "queue.type"));
        if (this.queue instanceof JRubyWrappedAckedQueueExt) {
            JRubyAckedQueueExt inner = ((JRubyWrappedAckedQueueExt)this.queue).rubyGetQueue();
            RubyString dirPath = inner.ruby_dir_path(context);
            AbstractNamespacedMetricExt capacityMetrics = pipelineMetric.namespace(context, (IRubyObject)CAPACITY_NAMESPACE);
            capacityMetrics.gauge(context, (IRubyObject)MetricKeys.PAGE_CAPACITY_IN_BYTES_KEY, inner.ruby_page_capacity(context));
            capacityMetrics.gauge(context, (IRubyObject)MetricKeys.MAX_QUEUE_SIZE_IN_BYTES_KEY, inner.ruby_max_size_in_bytes(context));
            capacityMetrics.gauge(context, (IRubyObject)MetricKeys.MAX_QUEUE_UNREAD_EVENTS_KEY, inner.ruby_max_unread_events(context));
            capacityMetrics.gauge(context, (IRubyObject)MetricKeys.QUEUE_SIZE_IN_BYTES_KEY, inner.ruby_persisted_size_in_bytes(context));
            AbstractNamespacedMetricExt dataMetrics = pipelineMetric.namespace(context, (IRubyObject)DATA_NAMESPACE);
            FileStore fileStore = Files.getFileStore(Paths.get(dirPath.asJavaString(), new String[0]));
            dataMetrics.gauge(context, (IRubyObject)MetricKeys.FREE_SPACE_IN_BYTES_KEY, (IRubyObject)context.runtime.newFixnum(fileStore.getUnallocatedSpace()));
            dataMetrics.gauge(context, (IRubyObject)MetricKeys.STORAGE_TYPE_KEY, (IRubyObject)context.runtime.newString(fileStore.type()));
            dataMetrics.gauge(context, (IRubyObject)MetricKeys.PATH_KEY, (IRubyObject)dirPath);
            pipelineMetric.gauge(context, (IRubyObject)MetricKeys.EVENTS_KEY, inner.ruby_unread_count(context));
        }
        return context.nil;
    }

    @JRubyMethod(name={"initialize_flow_metrics"})
    public final IRubyObject initializeFlowMetrics(ThreadContext context) {
        if (this.metric.collector(context).isNil()) {
            return context.nil;
        }
        if (!this.getSetting(context, "metric.collect").isTrue()) {
            return context.nil;
        }
        UptimeMetric uptimeMetric = this.initOrGetUptimeMetric(context, this.buildNamespace(new RubySymbol[0]), MetricKeys.UPTIME_IN_MILLIS_KEY);
        UptimeMetric.ScaledView uptimeInPreciseMillis = uptimeMetric.withUnitsPrecise(UptimeMetric.ScaleUnits.MILLISECONDS);
        UptimeMetric.ScaledView uptimeInPreciseSeconds = uptimeMetric.withUnitsPrecise(UptimeMetric.ScaleUnits.SECONDS);
        RubySymbol[] flowNamespace = this.buildNamespace(MetricKeys.FLOW_KEY);
        RubySymbol[] eventsNamespace = this.buildNamespace(MetricKeys.EVENTS_KEY);
        LongCounter eventsInCounter = this.initOrGetCounterMetric(context, eventsNamespace, MetricKeys.IN_KEY);
        FlowMetric inputThroughput = AbstractPipelineExt.createFlowMetric(MetricKeys.INPUT_THROUGHPUT_KEY, eventsInCounter, uptimeInPreciseSeconds);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.WORKER, inputThroughput);
        this.storeMetric(context, flowNamespace, inputThroughput);
        LongCounter eventsFilteredCounter = this.initOrGetCounterMetric(context, eventsNamespace, MetricKeys.FILTERED_KEY);
        FlowMetric filterThroughput = AbstractPipelineExt.createFlowMetric(MetricKeys.FILTER_THROUGHPUT_KEY, eventsFilteredCounter, uptimeInPreciseSeconds);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.WORKER, filterThroughput);
        this.storeMetric(context, flowNamespace, filterThroughput);
        LongCounter eventsOutCounter = this.initOrGetCounterMetric(context, eventsNamespace, MetricKeys.OUT_KEY);
        FlowMetric outputThroughput = AbstractPipelineExt.createFlowMetric(MetricKeys.OUTPUT_THROUGHPUT_KEY, eventsOutCounter, uptimeInPreciseSeconds);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.WORKER, outputThroughput);
        this.storeMetric(context, flowNamespace, outputThroughput);
        TimerMetric queuePushWaitInMillis = this.initOrGetTimerMetric(context, eventsNamespace, MetricKeys.PUSH_DURATION_KEY);
        FlowMetric backpressureFlow = AbstractPipelineExt.createFlowMetric(MetricKeys.QUEUE_BACKPRESSURE_KEY, queuePushWaitInMillis, uptimeInPreciseMillis);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.WORKER, backpressureFlow);
        this.storeMetric(context, flowNamespace, backpressureFlow);
        TimerMetric durationInMillis = this.initOrGetTimerMetric(context, eventsNamespace, MetricKeys.DURATION_IN_MILLIS_KEY);
        FlowMetric concurrencyFlow = AbstractPipelineExt.createFlowMetric(MetricKeys.WORKER_CONCURRENCY_KEY, durationInMillis, uptimeInPreciseMillis);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.WORKER, concurrencyFlow);
        this.storeMetric(context, flowNamespace, concurrencyFlow);
        int workerCount = this.getSetting(context, "pipeline.workers").convertToInteger().getIntValue();
        UpScaledMetric percentScaledDurationInMillis = new UpScaledMetric(durationInMillis, 100);
        UpScaledMetric availableWorkerTimeInMillis = new UpScaledMetric(uptimeInPreciseMillis, workerCount);
        FlowMetric utilizationFlow = AbstractPipelineExt.createFlowMetric(MetricKeys.WORKER_UTILIZATION_KEY, percentScaledDurationInMillis, availableWorkerTimeInMillis);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.WORKER, utilizationFlow);
        this.storeMetric(context, flowNamespace, utilizationFlow);
        this.initializePqFlowMetrics(context, flowNamespace, uptimeMetric);
        this.initializePluginFlowMetrics(context, uptimeMetric);
        return context.nil;
    }

    @JRubyMethod(name={"collect_flow_metrics"})
    public final IRubyObject collectFlowMetrics(ThreadContext context) {
        this.scopedFlowMetrics.captureAll();
        return context.nil;
    }

    public final PipelineIndicator.FlowObservation collectWorkerUtilizationFlowObservation() {
        return this.collectFlowObservation(MetricKeys.WORKER_UTILIZATION_KEY.asJavaString()::equals);
    }

    public final PipelineIndicator.FlowObservation collectFlowObservation(Predicate<String> filter) {
        Map<String, Map<String, Double>> collect = this.scopedFlowMetrics.getFlowMetrics(ScopedFlowMetrics.Scope.WORKER).stream().filter(fm -> filter.test(fm.getName())).collect(Collectors.toUnmodifiableMap(Metric::getName, Metric::getValue));
        return new PipelineIndicator.FlowObservation(collect);
    }

    private static FlowMetric createFlowMetric(RubySymbol name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric) {
        return FlowMetric.create(name.asJavaString(), numeratorMetric, denominatorMetric);
    }

    private static FlowMetric createFlowMetric(RubySymbol name, Supplier<? extends Metric<? extends Number>> numeratorMetricSupplier, Supplier<? extends Metric<? extends Number>> denominatorMetricSupplier) {
        return FlowMetric.create(name.asJavaString(), numeratorMetricSupplier, denominatorMetricSupplier);
    }

    private LongCounter initOrGetCounterMetric(ThreadContext context, RubySymbol[] subPipelineNamespacePath, RubySymbol metricName) {
        IRubyObject collector = this.metric.collector(context);
        RubyArray<RubySymbol> fullNamespace = this.pipelineNamespacedPath(subPipelineNamespacePath);
        IRubyObject retrievedMetric = collector.callMethod(context, "get", new IRubyObject[]{fullNamespace, metricName, context.runtime.newSymbol("counter")});
        return (LongCounter)retrievedMetric.toJava(LongCounter.class);
    }

    private TimerMetric initOrGetTimerMetric(ThreadContext context, RubySymbol[] subPipelineNamespacePath, RubySymbol metricName) {
        IRubyObject collector = this.metric.collector(context);
        RubyArray<RubySymbol> fullNamespace = this.pipelineNamespacedPath(subPipelineNamespacePath);
        IRubyObject retrievedMetric = collector.callMethod(context, "get", new IRubyObject[]{fullNamespace, metricName, context.runtime.newSymbol("timer")});
        return (TimerMetric)retrievedMetric.toJava(TimerMetric.class);
    }

    private Optional<NumberGauge> initOrGetNumberGaugeMetric(ThreadContext context, RubySymbol[] subPipelineNamespacePath, RubySymbol metricName) {
        RubyArray<RubySymbol> fullNamespace;
        IRubyObject collector = this.metric.collector(context);
        IRubyObject retrievedMetric = collector.callMethod(context, "get", new IRubyObject[]{fullNamespace = this.pipelineNamespacedPath(subPipelineNamespacePath), metricName, context.runtime.newSymbol("gauge")});
        LazyDelegatingGauge delegatingGauge = (LazyDelegatingGauge)retrievedMetric.toJava(LazyDelegatingGauge.class);
        if (Objects.isNull((Object)delegatingGauge.getType()) || delegatingGauge.getType() != MetricType.GAUGE_NUMBER) {
            return Optional.empty();
        }
        return Optional.of((NumberGauge)delegatingGauge.getMetric().get());
    }

    private UptimeMetric initOrGetUptimeMetric(ThreadContext context, RubySymbol[] subPipelineNamespacePath, RubySymbol uptimeMetricName) {
        IRubyObject collector = this.metric.collector(context);
        RubyArray<RubySymbol> fullNamespace = this.pipelineNamespacedPath(subPipelineNamespacePath);
        IRubyObject retrievedMetric = collector.callMethod(context, "get", new IRubyObject[]{fullNamespace, uptimeMetricName, context.runtime.newSymbol("uptime")});
        return (UptimeMetric)retrievedMetric.toJava(UptimeMetric.class);
    }

    private void initializePqFlowMetrics(ThreadContext context, RubySymbol[] flowNamespace, UptimeMetric uptime) {
        UptimeMetric.ScaledView uptimeInPreciseSeconds = uptime.withUnitsPrecise(UptimeMetric.ScaleUnits.SECONDS);
        IRubyObject queueContext = this.getSetting(context, QueueFactoryExt.QUEUE_TYPE_CONTEXT_NAME);
        if (!queueContext.isNil() && queueContext.asJavaString().equals(QueueFactoryExt.PERSISTED_TYPE)) {
            RubySymbol[] queueNamespace = this.buildNamespace(MetricKeys.QUEUE_KEY);
            RubySymbol[] queueCapacityNamespace = this.buildNamespace(MetricKeys.QUEUE_KEY, MetricKeys.CAPACITY_KEY);
            Supplier<NumberGauge> eventsGaugeMetricSupplier = () -> this.initOrGetNumberGaugeMetric(context, queueNamespace, MetricKeys.EVENTS_KEY).orElse(null);
            FlowMetric growthEventsFlow = AbstractPipelineExt.createFlowMetric(MetricKeys.QUEUE_PERSISTED_GROWTH_EVENTS_KEY, eventsGaugeMetricSupplier, () -> uptimeInPreciseSeconds);
            this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.WORKER, growthEventsFlow);
            this.storeMetric(context, flowNamespace, growthEventsFlow);
            Supplier<NumberGauge> queueSizeInBytesMetricSupplier = () -> this.initOrGetNumberGaugeMetric(context, queueCapacityNamespace, MetricKeys.QUEUE_SIZE_IN_BYTES_KEY).orElse(null);
            FlowMetric growthBytesFlow = AbstractPipelineExt.createFlowMetric(MetricKeys.QUEUE_PERSISTED_GROWTH_BYTES_KEY, queueSizeInBytesMetricSupplier, () -> uptimeInPreciseSeconds);
            this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.WORKER, growthBytesFlow);
            this.storeMetric(context, flowNamespace, growthBytesFlow);
        }
    }

    private void initializePluginFlowMetrics(ThreadContext context, UptimeMetric uptime) {
        for (IRubyObject rubyObject : this.lirExecution.inputs()) {
            IRubyObject iRubyObject = rubyObject.callMethod(context, "id");
            String id = iRubyObject.toString();
            this.initializePluginThroughputFlowMetric(context, uptime, id);
        }
        int workerCount = this.getSetting(context, "pipeline.workers").convertToInteger().getIntValue();
        for (AbstractFilterDelegatorExt abstractFilterDelegatorExt : this.lirExecution.filters()) {
            this.initializePluginWorkerFlowMetrics(context, workerCount, uptime, MetricKeys.FILTERS_KEY, abstractFilterDelegatorExt.getId().asJavaString());
        }
        for (AbstractOutputDelegatorExt abstractOutputDelegatorExt : this.lirExecution.outputs()) {
            this.initializePluginWorkerFlowMetrics(context, workerCount, uptime, MetricKeys.OUTPUTS_KEY, abstractOutputDelegatorExt.getId().asJavaString());
        }
    }

    private void initializePluginThroughputFlowMetric(ThreadContext context, UptimeMetric uptime, String id) {
        UptimeMetric.ScaledView uptimeInPreciseSeconds = uptime.withUnitsPrecise(UptimeMetric.ScaleUnits.SECONDS);
        RubySymbol[] eventsNamespace = this.buildNamespace(MetricKeys.PLUGINS_KEY, MetricKeys.INPUTS_KEY, RubyUtil.RUBY.newString(id).intern(), MetricKeys.EVENTS_KEY);
        LongCounter eventsOut = this.initOrGetCounterMetric(context, eventsNamespace, MetricKeys.OUT_KEY);
        FlowMetric throughputFlow = AbstractPipelineExt.createFlowMetric(MetricKeys.PLUGIN_THROUGHPUT_KEY, eventsOut, uptimeInPreciseSeconds);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.PLUGIN, throughputFlow);
        RubySymbol[] flowNamespace = this.buildNamespace(MetricKeys.PLUGINS_KEY, MetricKeys.INPUTS_KEY, RubyUtil.RUBY.newString(id).intern(), MetricKeys.FLOW_KEY);
        this.storeMetric(context, flowNamespace, throughputFlow);
    }

    private void initializePluginWorkerFlowMetrics(ThreadContext context, int workerCount, UptimeMetric uptime, RubySymbol key, String id) {
        UptimeMetric.ScaledView uptimeInPreciseMillis = uptime.withUnitsPrecise(UptimeMetric.ScaleUnits.MILLISECONDS);
        RubySymbol[] eventsNamespace = this.buildNamespace(MetricKeys.PLUGINS_KEY, key, RubyUtil.RUBY.newString(id).intern(), MetricKeys.EVENTS_KEY);
        TimerMetric durationInMillis = this.initOrGetTimerMetric(context, eventsNamespace, MetricKeys.DURATION_IN_MILLIS_KEY);
        LongCounter counterEvents = this.initOrGetCounterMetric(context, eventsNamespace, MetricKeys.IN_KEY);
        FlowMetric workerCostPerEvent = AbstractPipelineExt.createFlowMetric(MetricKeys.WORKER_MILLIS_PER_EVENT_KEY, durationInMillis, counterEvents);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.PLUGIN, workerCostPerEvent);
        UpScaledMetric percentScaledDurationInMillis = new UpScaledMetric(durationInMillis, 100);
        UpScaledMetric availableWorkerTimeInMillis = new UpScaledMetric(uptimeInPreciseMillis, workerCount);
        FlowMetric workerUtilization = AbstractPipelineExt.createFlowMetric(MetricKeys.WORKER_UTILIZATION_KEY, percentScaledDurationInMillis, availableWorkerTimeInMillis);
        this.scopedFlowMetrics.register(ScopedFlowMetrics.Scope.PLUGIN, workerUtilization);
        RubySymbol[] flowNamespace = this.buildNamespace(MetricKeys.PLUGINS_KEY, key, RubyUtil.RUBY.newString(id).intern(), MetricKeys.FLOW_KEY);
        this.storeMetric(context, flowNamespace, workerCostPerEvent);
        this.storeMetric(context, flowNamespace, workerUtilization);
    }

    private <T> void storeMetric(ThreadContext context, RubySymbol[] subPipelineNamespacePath, Metric<T> metric) {
        IRubyObject collector = this.metric.collector(context);
        RubyArray<RubySymbol> fullNamespace = this.pipelineNamespacedPath(subPipelineNamespacePath);
        RubySymbol metricKey = context.runtime.newString(metric.getName()).intern();
        IRubyObject wasRegistered = collector.callMethod(context, "register?", new IRubyObject[]{fullNamespace, metricKey, JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, metric)});
        if (!((Boolean)wasRegistered.toJava(Boolean.class)).booleanValue()) {
            LOGGER.warn(String.format("Metric registration error: `%s` could not be registered in namespace `%s`", metricKey, fullNamespace));
        } else {
            LOGGER.debug(String.format("Flow metric registered: `%s` in namespace `%s`", metricKey, fullNamespace));
        }
    }

    private RubyArray<RubySymbol> pipelineNamespacedPath(RubySymbol ... subPipelineNamespacePath) {
        RubySymbol[] pipelineNamespacePath = new RubySymbol[]{MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, this.pipelineId.asString().intern()};
        if (subPipelineNamespacePath.length == 0) {
            return this.rubySymbolArray(pipelineNamespacePath);
        }
        RubySymbol[] fullNamespacePath = Arrays.copyOf(pipelineNamespacePath, pipelineNamespacePath.length + subPipelineNamespacePath.length);
        System.arraycopy(subPipelineNamespacePath, 0, fullNamespacePath, pipelineNamespacePath.length, subPipelineNamespacePath.length);
        return this.rubySymbolArray(fullNamespacePath);
    }

    private RubyArray<RubySymbol> rubySymbolArray(RubySymbol[] symbols) {
        return this.getRuntime().newArray((IRubyObject[])symbols);
    }

    private RubySymbol[] buildNamespace(RubySymbol ... namespace) {
        return namespace;
    }

    @JRubyMethod(name={"input_queue_client"})
    public final JRubyAbstractQueueWriteClientExt inputQueueClient() {
        return this.inputQueueClient;
    }

    @JRubyMethod
    public final AbstractWrappedQueueExt queue() {
        return this.queue;
    }

    @JRubyMethod
    public final IRubyObject close(ThreadContext context) throws IOException {
        this.filterQueueClient.close();
        this.queue.close(context);
        this.closeDlqWriter(context);
        return context.nil;
    }

    @JRubyMethod(name={"wrapped_write_client"}, visibility=Visibility.PROTECTED)
    public final JRubyWrappedWriteClientExt wrappedWriteClient(ThreadContext context, IRubyObject pluginId) {
        return new JRubyWrappedWriteClientExt(context.runtime, RubyUtil.WRAPPED_WRITE_CLIENT_CLASS).initialize(this.inputQueueClient, this.pipelineId.asJavaString(), this.metric, pluginId);
    }

    public QueueWriter getQueueWriter(String inputName) {
        return new JRubyWrappedWriteClientExt(RubyUtil.RUBY, RubyUtil.WRAPPED_WRITE_CLIENT_CLASS).initialize(RubyUtil.RUBY.getCurrentContext(), new IRubyObject[]{this.inputQueueClient(), this.pipelineId().convertToString().intern(), this.metric(), RubyUtil.RUBY.newString(inputName).intern()});
    }

    @JRubyMethod(name={"pipeline_source_details"}, visibility=Visibility.PROTECTED)
    public RubyArray getPipelineSourceDetails(ThreadContext context) {
        ArrayList<RubyString> pipelineSources = new ArrayList<RubyString>(this.configParts.size());
        for (SourceWithMetadata sourceWithMetadata : this.configParts) {
            String protocol;
            switch (protocol = sourceWithMetadata.getProtocol()) {
                case "string": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)"config string"));
                    break;
                }
                case "file": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)sourceWithMetadata.getId()));
                    break;
                }
                case "x-pack-metrics": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)"monitoring pipeline"));
                    break;
                }
                case "x-pack-config-management": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)"central pipeline management"));
                    break;
                }
                case "module": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)"module"));
                }
            }
        }
        return RubyArray.newArray((Ruby)context.runtime, pipelineSources);
    }

    protected final IRubyObject getSetting(ThreadContext context, String name) {
        return this.settings.callMethod(context, "get_value", (IRubyObject)context.runtime.newString(name));
    }

    protected final boolean hasSetting(ThreadContext context, String name) {
        return this.settings.callMethod(context, "registered?", (IRubyObject)context.runtime.newString(name)) == context.tru;
    }

    protected SecretStore getSecretStore(ThreadContext context) {
        String keystoreFile = this.hasSetting(context, "keystore.file") ? this.getSetting(context, "keystore.file").asJavaString() : null;
        String keystoreClassname = this.hasSetting(context, "keystore.classname") ? this.getSetting(context, "keystore.classname").asJavaString() : null;
        return keystoreFile != null && keystoreClassname != null ? SecretStoreExt.getIfExists(keystoreFile, keystoreClassname) : null;
    }

    private AbstractNamespacedMetricExt getDlqMetric(ThreadContext context) {
        if (this.dlqMetric == null) {
            this.dlqMetric = this.metric.namespace(context, (IRubyObject)this.pipelineNamespacedPath(MetricKeys.DLQ_KEY));
        }
        return this.dlqMetric;
    }

    @JRubyMethod
    public RubyArray inputs() {
        return this.inputs;
    }

    @JRubyMethod
    public RubyArray filters() {
        return this.filters;
    }

    @JRubyMethod
    public RubyArray outputs() {
        return this.outputs;
    }

    @JRubyMethod(name={"shutdown_requested?"})
    public IRubyObject isShutdownRequested(ThreadContext context) {
        throw new IllegalStateException("Pipeline implementation does not provide `shutdown_requested?`, which is a Logstash internal error.");
    }

    @JRubyMethod(name={"last_error_evaluation_received"})
    @VisibleForTesting
    public final RubyString getLastErrorEvaluationReceived(ThreadContext context) {
        return RubyString.newString((Ruby)context.runtime, (String)this.lastErrorEvaluationReceived);
    }

    private static class ScopedFlowMetrics {
        private final Map<Scope, List<FlowMetric>> flowsByScope = new ConcurrentHashMap<Scope, List<FlowMetric>>();

        private ScopedFlowMetrics() {
        }

        void register(Scope scope, FlowMetric metric) {
            this.flowsByScope.compute(scope, (s, scopedFlows) -> {
                if (scopedFlows == null) {
                    return List.of(metric);
                }
                ArrayList<FlowMetric> mutable = new ArrayList<FlowMetric>(scopedFlows.size() + 1);
                mutable.addAll((Collection<FlowMetric>)scopedFlows);
                mutable.add(metric);
                return List.copyOf(mutable);
            });
        }

        void captureAll() {
            this.flowsByScope.values().stream().flatMap(Collection::stream).forEach(FlowMetric::capture);
        }

        List<FlowMetric> getFlowMetrics(Scope scope) {
            return this.flowsByScope.getOrDefault((Object)scope, List.of());
        }

        static enum Scope {
            WORKER,
            PLUGIN;

        }
    }

    public final class LogErrorEvaluationListener
    implements ConditionalEvaluationListener {
        @Override
        public void notify(ConditionalEvaluationError err) {
            AbstractPipelineExt.this.lastErrorEvaluationReceived = err.getCause().getMessage();
            if (this.isDLQEnabled()) {
                LOGGER.warn("{}. Failing event was sent to dead letter queue", (Object)AbstractPipelineExt.this.lastErrorEvaluationReceived);
            } else {
                LOGGER.warn("{}. Event was dropped, enable debug logging to see the event's payload", (Object)AbstractPipelineExt.this.lastErrorEvaluationReceived);
            }
            LOGGER.debug("Event generating the fault: {}", (Object)err.failedEvent().toMap().toString());
            if (LOGGER.isDebugEnabled()) {
                this.debugLogStackTrace(err);
            }
            if (this.isDLQEnabled()) {
                try {
                    AbstractPipelineExt.this.javaDlqWriter.writeEntry(err.failedEvent(), "if-statement", "if-statement", "condition evaluation error, " + AbstractPipelineExt.this.lastErrorEvaluationReceived);
                }
                catch (IOException ioex) {
                    LOGGER.error("Can't write in DLQ", (Throwable)ioex);
                }
            }
        }

        private boolean isDLQEnabled() {
            return AbstractPipelineExt.this.javaDlqWriter != null;
        }

        private void debugLogStackTrace(ConditionalEvaluationError err) {
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                err.printStackTrace(pw);
                LOGGER.debug("{}", (Object)sw);
            }
            catch (IOException ioex) {
                LOGGER.warn("Invalid operation on closing internal resources", (Throwable)ioex);
            }
        }
    }

    public static interface ConditionalEvaluationListener {
        public void notify(ConditionalEvaluationError var1);
    }
}

