/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.InternalCartesianBounds;

public abstract class CartesianBoundsAggregatorBase
extends MetricsAggregator {
    private DoubleArray tops = this.bigArrays().newDoubleArray(1L, false);
    private DoubleArray bottoms;
    private DoubleArray lefts;
    private DoubleArray rights;

    public CartesianBoundsAggregatorBase(String name, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.tops.fill(0L, this.tops.size(), Double.NEGATIVE_INFINITY);
        this.bottoms = this.bigArrays().newDoubleArray(1L, false);
        this.bottoms.fill(0L, this.bottoms.size(), Double.POSITIVE_INFINITY);
        this.lefts = this.bigArrays().newDoubleArray(1L, false);
        this.lefts.fill(0L, this.lefts.size(), Double.POSITIVE_INFINITY);
        this.rights = this.bigArrays().newDoubleArray(1L, false);
        this.rights.fill(0L, this.rights.size(), Double.NEGATIVE_INFINITY);
    }

    protected void addBounds(long bucket, double top, double bottom, double left, double right) {
        this.tops.set(bucket, Math.max(this.tops.get(bucket), top));
        this.bottoms.set(bucket, Math.min(this.bottoms.get(bucket), bottom));
        this.lefts.set(bucket, Math.min(this.lefts.get(bucket), left));
        this.rights.set(bucket, Math.max(this.rights.get(bucket), right));
    }

    protected void maybeResize(long bucket) {
        if (bucket >= this.tops.size()) {
            long from = this.tops.size();
            this.tops = this.bigArrays().grow(this.tops, bucket + 1L);
            this.tops.fill(from, this.tops.size(), Double.NEGATIVE_INFINITY);
            this.bottoms = this.bigArrays().resize(this.bottoms, this.tops.size());
            this.bottoms.fill(from, this.bottoms.size(), Double.POSITIVE_INFINITY);
            this.lefts = this.bigArrays().resize(this.lefts, this.tops.size());
            this.lefts.fill(from, this.lefts.size(), Double.POSITIVE_INFINITY);
            this.rights = this.bigArrays().resize(this.rights, this.tops.size());
            this.rights.fill(from, this.rights.size(), Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (owningBucketOrdinal >= this.tops.size()) {
            return this.buildEmptyAggregation();
        }
        double top = this.tops.get(owningBucketOrdinal);
        double bottom = this.bottoms.get(owningBucketOrdinal);
        double left = this.lefts.get(owningBucketOrdinal);
        double right = this.rights.get(owningBucketOrdinal);
        return new InternalCartesianBounds(this.name, top, bottom, left, right, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalCartesianBounds.empty(this.name, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.tops, this.bottoms, this.lefts, this.rights);
    }
}

