/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.spatial.search.aggregations.InternalGeoLine;
import org.elasticsearch.xpack.spatial.search.aggregations.TimeSeriesGeoLineBuckets;

abstract class MergedGeoLines {
    protected final List<InternalGeoLine> geoLines;
    protected final SortOrder sortOrder;
    protected final boolean simplify;
    protected int size;
    protected final long[] finalPoints;
    protected final double[] finalSortValues;

    private MergedGeoLines(List<InternalGeoLine> geoLines, int finalLength, SortOrder sortOrder, boolean simplify) {
        this.geoLines = geoLines;
        this.sortOrder = sortOrder;
        this.simplify = simplify;
        this.size = 0;
        this.finalPoints = new long[finalLength];
        this.finalSortValues = new double[finalLength];
    }

    public long[] getFinalPoints() {
        return this.finalPoints;
    }

    public double[] getFinalSortValues() {
        return this.finalSortValues;
    }

    public abstract void merge();

    static final class NonOverlapping
    extends MergedGeoLines {
        private static final Comparator<InternalGeoLine> DESC_COMPARATOR = (o1, o2) -> Double.compare(o2.sortVals()[0], o1.sortVals()[0]);
        private static final Comparator<InternalGeoLine> ASC_COMPARATOR = Comparator.comparingDouble(o -> o.sortVals()[0]);

        NonOverlapping(List<InternalGeoLine> geoLines, int finalLength, SortOrder sortOrder, boolean simplify) {
            super(geoLines, finalLength, sortOrder, simplify);
        }

        @Override
        public void merge() {
            TreeSet<InternalGeoLine> sorted = this.sortOrder == SortOrder.DESC ? new TreeSet<InternalGeoLine>(DESC_COMPARATOR) : new TreeSet<InternalGeoLine>(ASC_COMPARATOR);
            for (InternalGeoLine line : this.geoLines) {
                if (line.length() <= 0) continue;
                sorted.add(line);
            }
            if (this.simplify) {
                this.mergeAndSimplify(sorted);
            } else {
                this.mergeAndTruncate(sorted);
            }
        }

        private void mergeAndSimplify(TreeSet<InternalGeoLine> sorted) {
            TimeSeriesGeoLineBuckets.Simplifier simplifier = new TimeSeriesGeoLineBuckets.Simplifier(this.finalSortValues.length, v -> v);
            int index = 0;
            for (InternalGeoLine geoLine : sorted) {
                double[] values = geoLine.sortVals();
                long[] points = geoLine.line();
                for (int i = 0; i < values.length; ++i) {
                    double x = GeoEncodingUtils.decodeLongitude((int)(points[i] >>> 32));
                    double y = GeoEncodingUtils.decodeLatitude((int)(points[i] & 0xFFFFFFFFL));
                    TimeSeriesGeoLineBuckets.SimplifiablePoint point = new TimeSeriesGeoLineBuckets.SimplifiablePoint(index, x, y, values[i]);
                    simplifier.consume(point);
                    ++index;
                }
            }
            TimeSeriesGeoLineBuckets.LineStream simplified = simplifier.produce();
            this.size = 0;
            while (this.size < simplified.sortValues.length) {
                this.finalSortValues[this.size] = simplified.sortValues[this.size];
                this.finalPoints[this.size] = simplified.encodedPoints[this.size];
                ++this.size;
            }
        }

        private void mergeAndTruncate(TreeSet<InternalGeoLine> sorted) {
            for (InternalGeoLine geoLine : sorted) {
                double[] values = geoLine.sortVals();
                long[] points = geoLine.line();
                for (int doc = 0; this.size < this.finalPoints.length && doc < geoLine.length(); ++doc) {
                    this.finalPoints[this.size] = points[doc];
                    this.finalSortValues[this.size] = values[doc];
                    ++this.size;
                }
            }
        }
    }

    static final class Overlapping
    extends MergedGeoLines {
        private final int capacity;
        private final int[] lineIndices;
        private final int[] idxsWithinLine;

        Overlapping(List<InternalGeoLine> geoLines, int finalLength, SortOrder sortOrder, boolean simplify) {
            super(geoLines, finalLength, sortOrder, simplify);
            if (simplify) {
                throw new IllegalArgumentException("Unsupported option - simplification of overlapping geo_lines during reduce phase");
            }
            this.capacity = geoLines.size();
            this.lineIndices = new int[this.capacity];
            this.idxsWithinLine = new int[this.capacity];
        }

        @Override
        public void merge() {
            int i;
            for (i = 0; i < this.geoLines.size(); ++i) {
                if (((InternalGeoLine)this.geoLines.get(i)).length() <= 0) continue;
                this.add(i, 0);
            }
            for (i = 0; i < this.finalPoints.length && this.size > 0; ++i) {
                int lineIdx = this.lineIndices[0];
                int idxInLine = this.idxsWithinLine[0];
                this.finalPoints[i] = this.getTopPoint();
                this.finalSortValues[i] = this.getTopSortValue();
                this.removeTop();
                InternalGeoLine lineChosen = (InternalGeoLine)this.geoLines.get(lineIdx);
                if (idxInLine + 1 >= lineChosen.length()) continue;
                this.add(lineIdx, idxInLine + 1);
            }
        }

        private long getTopPoint() {
            InternalGeoLine line = (InternalGeoLine)this.geoLines.get(this.lineIndices[0]);
            return line.line()[this.idxsWithinLine[0]];
        }

        private double getTopSortValue() {
            InternalGeoLine line = (InternalGeoLine)this.geoLines.get(this.lineIndices[0]);
            return line.sortVals()[this.idxsWithinLine[0]];
        }

        private void removeTop() {
            if (this.size == 0) {
                throw new IllegalStateException();
            }
            this.lineIndices[0] = this.lineIndices[this.size - 1];
            this.idxsWithinLine[0] = this.idxsWithinLine[this.size - 1];
            --this.size;
            this.heapifyDown();
        }

        private void add(int lineIndex, int idxWithinLine) {
            if (this.size >= this.capacity) {
                throw new IllegalStateException();
            }
            this.lineIndices[this.size] = lineIndex;
            this.idxsWithinLine[this.size] = idxWithinLine;
            ++this.size;
            this.heapifyUp();
        }

        private boolean correctOrdering(int i, int j) {
            InternalGeoLine lineI = (InternalGeoLine)this.geoLines.get(this.lineIndices[i]);
            InternalGeoLine lineJ = (InternalGeoLine)this.geoLines.get(this.lineIndices[j]);
            double valI = lineI.sortVals()[this.idxsWithinLine[i]];
            double valJ = lineJ.sortVals()[this.idxsWithinLine[j]];
            if (SortOrder.ASC.equals(this.sortOrder)) {
                return valI > valJ;
            }
            return valI < valJ;
        }

        private int getParentIndex(int i) {
            return (i - 1) / 2;
        }

        private int getLeftChildIndex(int i) {
            return 2 * i + 1;
        }

        private int getRightChildIndex(int i) {
            return 2 * i + 2;
        }

        private boolean hasParent(int i) {
            return i > 0;
        }

        private boolean hasLeftChild(int i) {
            return this.getLeftChildIndex(i) < this.size;
        }

        private boolean hasRightChild(int i) {
            return this.getRightChildIndex(i) < this.size;
        }

        private void heapifyUp() {
            int i = this.size - 1;
            while (this.hasParent(i) && this.correctOrdering(this.getParentIndex(i), i)) {
                int parentIndex = this.getParentIndex(i);
                this.swap(parentIndex, i);
                i = parentIndex;
            }
        }

        private void heapifyDown() {
            int i = 0;
            while (this.hasLeftChild(i)) {
                int childIndex = this.getLeftChildIndex(i);
                if (this.hasRightChild(i) && !this.correctOrdering(this.getRightChildIndex(i), childIndex)) {
                    childIndex = this.getRightChildIndex(i);
                }
                if (this.correctOrdering(childIndex, i)) break;
                this.swap(childIndex, i);
                i = childIndex;
            }
        }

        private void swap(int i, int j) {
            int tmpLineIndex = this.lineIndices[i];
            int tmpIdxWithinLine = this.idxsWithinLine[i];
            this.lineIndices[i] = this.lineIndices[j];
            this.idxsWithinLine[i] = this.idxsWithinLine[j];
            this.lineIndices[j] = tmpLineIndex;
            this.idxsWithinLine[j] = tmpIdxWithinLine;
        }
    }
}

