/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissionGroup;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;

public class RemoteClusterPermissions
implements NamedWriteable,
ToXContentObject {
    public static final TransportVersion ROLE_REMOTE_CLUSTER_PRIVS = TransportVersions.V_8_15_0;
    public static final TransportVersion ROLE_MONITOR_STATS = TransportVersions.V_8_17_0;
    public static final String NAME = "remote_cluster_permissions";
    private static final Logger logger = LogManager.getLogger(RemoteClusterPermissions.class);
    private final List<RemoteClusterPermissionGroup> remoteClusterPermissionGroups;
    static Map<TransportVersion, Set<String>> allowedRemoteClusterPermissions = Map.of(ROLE_REMOTE_CLUSTER_PRIVS, Set.of(ClusterPrivilegeResolver.MONITOR_ENRICH.name()), ROLE_MONITOR_STATS, Set.of(ClusterPrivilegeResolver.MONITOR_STATS.name()));
    static final TransportVersion lastTransportVersionPermission = (TransportVersion)allowedRemoteClusterPermissions.keySet().stream().max(VersionId::compareTo).orElseThrow();
    public static final RemoteClusterPermissions NONE = new RemoteClusterPermissions();

    public static Set<String> getSupportedRemoteClusterPermissions() {
        return allowedRemoteClusterPermissions.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new));
    }

    public RemoteClusterPermissions(StreamInput in) throws IOException {
        this.remoteClusterPermissionGroups = in.readNamedWriteableCollectionAsList(RemoteClusterPermissionGroup.class);
    }

    public RemoteClusterPermissions(List<Map<String, List<String>>> remoteClusters) {
        this.remoteClusterPermissionGroups = new ArrayList<RemoteClusterPermissionGroup>();
        for (Map<String, List<String>> remoteCluster : remoteClusters) {
            RemoteClusterPermissionGroup remoteClusterPermissionGroup = new RemoteClusterPermissionGroup(remoteCluster);
            this.remoteClusterPermissionGroups.add(remoteClusterPermissionGroup);
        }
    }

    public RemoteClusterPermissions() {
        this.remoteClusterPermissionGroups = new ArrayList<RemoteClusterPermissionGroup>();
    }

    public RemoteClusterPermissions addGroup(RemoteClusterPermissionGroup remoteClusterPermissionGroup) {
        Objects.requireNonNull(remoteClusterPermissionGroup, "remoteClusterPermissionGroup must not be null");
        if (this == NONE) {
            throw new IllegalArgumentException("Cannot add a group to the `NONE` instance");
        }
        this.remoteClusterPermissionGroups.add(remoteClusterPermissionGroup);
        return this;
    }

    public RemoteClusterPermissions removeUnsupportedPrivileges(TransportVersion outboundVersion) {
        Objects.requireNonNull(outboundVersion, "outboundVersion must not be null");
        if (outboundVersion.onOrAfter(lastTransportVersionPermission)) {
            return this;
        }
        RemoteClusterPermissions copyForOutboundVersion = new RemoteClusterPermissions();
        Set<String> allowedPermissionsPerVersion = this.getAllowedPermissionsPerVersion(outboundVersion);
        for (RemoteClusterPermissionGroup group : this.remoteClusterPermissionGroups) {
            String[] privileges = group.clusterPrivileges();
            ArrayList<String> outboundPrivileges = new ArrayList<String>(privileges.length);
            for (String privilege : privileges) {
                if (!allowedPermissionsPerVersion.contains(privilege.toLowerCase(Locale.ROOT))) continue;
                outboundPrivileges.add(privilege);
            }
            if (!outboundPrivileges.isEmpty()) {
                RemoteClusterPermissionGroup outboundGroup = new RemoteClusterPermissionGroup(outboundPrivileges.toArray(new String[0]), group.remoteClusterAliases());
                copyForOutboundVersion.addGroup(outboundGroup);
                if (!logger.isDebugEnabled() || group.equals(outboundGroup)) continue;
                logger.debug("Removed unsupported remote cluster permissions. Remaining {} for remote cluster [{}] for version [{}].Due to the remote cluster version, only the following permissions are allowed: {}", outboundPrivileges, (Object)group.remoteClusterAliases(), (Object)outboundVersion, allowedPermissionsPerVersion);
                continue;
            }
            logger.debug("Removed all remote cluster permissions for remote cluster [{}]. Due to the remote cluster version, only the following permissions are allowed: {}", (Object)group.remoteClusterAliases(), allowedPermissionsPerVersion);
        }
        return copyForOutboundVersion;
    }

    public String[] collapseAndRemoveUnsupportedPrivileges(String remoteClusterAlias, TransportVersion outboundVersion) {
        Set<String> allowedPermissionsPerVersion;
        Set groupPrivileges = this.remoteClusterPermissionGroups.stream().filter(group -> group.hasPrivileges(remoteClusterAlias)).flatMap(groups -> Arrays.stream(groups.clusterPrivileges())).distinct().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        HashSet allowedPrivileges = new HashSet(groupPrivileges);
        boolean hasRemovedPrivileges = allowedPrivileges.retainAll(allowedPermissionsPerVersion = this.getAllowedPermissionsPerVersion(outboundVersion));
        if (hasRemovedPrivileges) {
            HashSet removedPrivileges = new HashSet(groupPrivileges);
            removedPrivileges.removeAll(allowedPermissionsPerVersion);
            logger.info("Removed unsupported remote cluster permissions {} for remote cluster [{}]. Due to the remote cluster version, only the following permissions are allowed: {}", removedPrivileges, (Object)remoteClusterAlias, allowedPrivileges);
        }
        return (String[])allowedPrivileges.stream().sorted().toArray(String[]::new);
    }

    public List<Map<String, List<String>>> toMap() {
        return this.remoteClusterPermissionGroups.stream().map(RemoteClusterPermissionGroup::toMap).toList();
    }

    public void validate() {
        assert (this.hasAnyPrivileges());
        Set<String> invalid = this.getUnsupportedPrivileges();
        if (!invalid.isEmpty()) {
            throw new IllegalArgumentException("Invalid remote_cluster permissions found. Please remove the following: " + String.valueOf(invalid) + " Only " + String.valueOf(RemoteClusterPermissions.getSupportedRemoteClusterPermissions()) + " are allowed");
        }
    }

    private Set<String> getUnsupportedPrivileges() {
        HashSet<String> invalid = new HashSet<String>();
        for (RemoteClusterPermissionGroup group : this.remoteClusterPermissionGroups) {
            for (String namedPrivilege : group.clusterPrivileges()) {
                String toCheck = namedPrivilege.toLowerCase(Locale.ROOT);
                if (RemoteClusterPermissions.getSupportedRemoteClusterPermissions().contains(toCheck)) continue;
                invalid.add(namedPrivilege);
            }
        }
        return invalid;
    }

    public boolean hasAnyPrivileges(String remoteClusterAlias) {
        return this.remoteClusterPermissionGroups.stream().anyMatch(remoteIndicesGroup -> remoteIndicesGroup.hasPrivileges(remoteClusterAlias));
    }

    public boolean hasAnyPrivileges() {
        return !this.remoteClusterPermissionGroups.isEmpty();
    }

    public List<RemoteClusterPermissionGroup> groups() {
        return Collections.unmodifiableList(this.remoteClusterPermissionGroups);
    }

    private Set<String> getAllowedPermissionsPerVersion(TransportVersion outboundVersion) {
        return allowedRemoteClusterPermissions.entrySet().stream().filter(entry -> ((TransportVersion)entry.getKey()).onOrBefore(outboundVersion)).map(Map.Entry::getValue).flatMap(Collection::stream).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (RemoteClusterPermissionGroup remoteClusterPermissionGroup : this.remoteClusterPermissionGroups) {
            builder.value(remoteClusterPermissionGroup);
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableCollection(this.remoteClusterPermissionGroups);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteClusterPermissions that = (RemoteClusterPermissions)o;
        return Objects.equals(this.remoteClusterPermissionGroups, that.remoteClusterPermissionGroups);
    }

    public int hashCode() {
        return Objects.hash(this.remoteClusterPermissionGroups);
    }

    public String toString() {
        return "RemoteClusterPermissions{remoteClusterPermissionGroups=" + String.valueOf(this.remoteClusterPermissionGroups) + "}";
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

