/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.license.License;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelInput;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr.LearningToRankFeatureExtractorBuilder;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr.QueryExtractorBuilder;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class LearningToRankConfig
extends RegressionConfig
implements Rewriteable<LearningToRankConfig> {
    public static final ParseField NAME = new ParseField("learning_to_rank", new String[0]);
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    public static final ParseField FEATURE_EXTRACTORS = new ParseField("feature_extractors", new String[0]);
    public static final ParseField DEFAULT_PARAMS = new ParseField("default_params", new String[0]);
    public static final LearningToRankConfig EMPTY_PARAMS = new LearningToRankConfig(null, null, null);
    private static final ObjectParser<Builder, Boolean> LENIENT_PARSER = LearningToRankConfig.createParser(true);
    private static final ObjectParser<Builder, Boolean> STRICT_PARSER = LearningToRankConfig.createParser(false);
    private static final TrainedModelInput DEFAULT_INPUT = new TrainedModelInput(List.of());
    private final List<LearningToRankFeatureExtractorBuilder> featureExtractorBuilders;
    private final Map<String, Object> paramsDefaults;

    private static ObjectParser<Builder, Boolean> createParser(boolean lenient) {
        ObjectParser<Builder, Boolean> parser = new ObjectParser<Builder, Boolean>(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareInt(Builder::setNumTopFeatureImportanceValues, NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        parser.declareNamedObjects(Builder::setLearningToRankFeatureExtractorBuilders, (p, c, n) -> p.namedObject(LearningToRankFeatureExtractorBuilder.class, n, lenient), b -> {}, FEATURE_EXTRACTORS);
        parser.declareObject(Builder::setParamsDefaults, (p, c) -> p.map(), DEFAULT_PARAMS);
        return parser;
    }

    public static LearningToRankConfig fromXContentStrict(XContentParser parser) {
        return STRICT_PARSER.apply(parser, null).build();
    }

    public static LearningToRankConfig fromXContentLenient(XContentParser parser) {
        return LENIENT_PARSER.apply(parser, null).build();
    }

    public static Builder builder(LearningToRankConfig config) {
        return new Builder(config);
    }

    public LearningToRankConfig(Integer numTopFeatureImportanceValues, List<LearningToRankFeatureExtractorBuilder> featureExtractorBuilders, Map<String, Object> paramsDefaults) {
        super("predicted_value", numTopFeatureImportanceValues);
        Set featureNames;
        if (featureExtractorBuilders != null && (featureNames = featureExtractorBuilders.stream().map(LearningToRankFeatureExtractorBuilder::featureName).collect(Collectors.toSet())).size() < featureExtractorBuilders.size()) {
            throw new IllegalArgumentException("[" + FEATURE_EXTRACTORS.getPreferredName() + "] contains duplicate [feature_name] values");
        }
        this.featureExtractorBuilders = Collections.unmodifiableList(Objects.requireNonNullElse(featureExtractorBuilders, List.of()));
        this.paramsDefaults = Collections.unmodifiableMap(Objects.requireNonNullElse(paramsDefaults, Map.of()));
    }

    public LearningToRankConfig(StreamInput in) throws IOException {
        super(in);
        this.featureExtractorBuilders = in.readNamedWriteableCollectionAsList(LearningToRankFeatureExtractorBuilder.class);
        this.paramsDefaults = in.readGenericMap();
    }

    public List<LearningToRankFeatureExtractorBuilder> getFeatureExtractorBuilders() {
        return this.featureExtractorBuilders;
    }

    public List<QueryExtractorBuilder> getQueryFeatureExtractorBuilders() {
        ArrayList<QueryExtractorBuilder> queryExtractorBuilders = new ArrayList<QueryExtractorBuilder>();
        for (LearningToRankFeatureExtractorBuilder featureExtractorBuilder : this.featureExtractorBuilders) {
            if (!(featureExtractorBuilder instanceof QueryExtractorBuilder)) continue;
            QueryExtractorBuilder queryExtractorBuilder = (QueryExtractorBuilder)featureExtractorBuilder;
            queryExtractorBuilders.add(queryExtractorBuilder);
        }
        return queryExtractorBuilders;
    }

    @Override
    public String getResultsField() {
        return "predicted_value";
    }

    public Map<String, Object> getParamsDefaults() {
        return this.paramsDefaults;
    }

    @Override
    public boolean isAllocateOnly() {
        return false;
    }

    @Override
    public boolean supportsIngestPipeline() {
        return false;
    }

    @Override
    public boolean supportsPipelineAggregation() {
        return false;
    }

    @Override
    public boolean supportsSearchRescorer() {
        return true;
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteableCollection(this.featureExtractorBuilders);
        out.writeGenericMap(this.paramsDefaults);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.getNumTopFeatureImportanceValues());
        if (!this.featureExtractorBuilders.isEmpty()) {
            NamedXContentObjectHelper.writeNamedObjects(builder, params, true, FEATURE_EXTRACTORS.getPreferredName(), this.featureExtractorBuilders);
        }
        if (!this.paramsDefaults.isEmpty()) {
            builder.field(DEFAULT_PARAMS.getPreferredName(), this.paramsDefaults);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LearningToRankConfig that = (LearningToRankConfig)o;
        return Objects.equals(this.featureExtractorBuilders, that.featureExtractorBuilders) && Objects.equals(this.paramsDefaults, that.paramsDefaults);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.featureExtractorBuilders, this.paramsDefaults);
    }

    public final String toString() {
        return Strings.toString(this);
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return TargetType.REGRESSION.equals(targetType);
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.CURRENT;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersions.V_8_16_0;
    }

    @Override
    public License.OperationMode getMinLicenseSupportedForAction(RestRequest.Method method) {
        if (method == RestRequest.Method.PUT) {
            return License.OperationMode.ENTERPRISE;
        }
        return super.getMinLicenseSupportedForAction(method);
    }

    @Override
    public LearningToRankConfig rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.featureExtractorBuilders.isEmpty()) {
            return this;
        }
        boolean rewritten = false;
        ArrayList<LearningToRankFeatureExtractorBuilder> rewrittenExtractors = new ArrayList<LearningToRankFeatureExtractorBuilder>(this.featureExtractorBuilders.size());
        for (LearningToRankFeatureExtractorBuilder extractorBuilder : this.featureExtractorBuilders) {
            LearningToRankFeatureExtractorBuilder rewrittenExtractor = Rewriteable.rewrite(extractorBuilder, ctx);
            rewrittenExtractors.add(rewrittenExtractor);
            rewritten |= rewrittenExtractor != extractorBuilder;
        }
        if (rewritten) {
            return new LearningToRankConfig(this.getNumTopFeatureImportanceValues(), rewrittenExtractors, this.paramsDefaults);
        }
        return this;
    }

    @Override
    public TrainedModelInput getDefaultInput(TrainedModelType modelType) {
        return DEFAULT_INPUT;
    }

    @Override
    public ActionRequestValidationException validateTrainedModelInput(TrainedModelInput input, boolean forCreation, ActionRequestValidationException validationException) {
        if (forCreation && input != null && !input.getFieldNames().isEmpty()) {
            return ValidateActions.addValidationError("cannot specify [input.field_names] for a model of type [learning_to_rank]", validationException);
        }
        return validationException;
    }

    public static class Builder {
        private Integer numTopFeatureImportanceValues;
        private List<LearningToRankFeatureExtractorBuilder> learningToRankFeatureExtractorBuilders;
        private Map<String, Object> paramsDefaults = Map.of();

        Builder() {
        }

        Builder(LearningToRankConfig config) {
            this.numTopFeatureImportanceValues = config.getNumTopFeatureImportanceValues();
            this.learningToRankFeatureExtractorBuilders = config.featureExtractorBuilders;
            this.paramsDefaults = config.getParamsDefaults();
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setLearningToRankFeatureExtractorBuilders(List<LearningToRankFeatureExtractorBuilder> learningToRankFeatureExtractorBuilders) {
            this.learningToRankFeatureExtractorBuilders = learningToRankFeatureExtractorBuilders;
            return this;
        }

        public Builder setParamsDefaults(Map<String, Object> paramsDefaults) {
            this.paramsDefaults = paramsDefaults;
            return this;
        }

        public LearningToRankConfig build() {
            return new LearningToRankConfig(this.numTopFeatureImportanceValues, this.learningToRankFeatureExtractorBuilders, this.paramsDefaults);
        }
    }
}

