/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.util.Collections;
import java.util.Locale;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelInput;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.IndexLocation;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModelLocation;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.Ensemble;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.langident.LangIdentNeuralNetwork;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.tree.Tree;

public enum TrainedModelType {
    TREE_ENSEMBLE(null),
    LANG_IDENT(null),
    PYTORCH(new TrainedModelInput(Collections.singletonList("input")));

    private final TrainedModelInput defaultInput;

    public static TrainedModelType fromString(String name) {
        return TrainedModelType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static TrainedModelType typeFromTrainedModel(TrainedModel model) {
        if (model instanceof Ensemble || model instanceof Tree) {
            return TREE_ENSEMBLE;
        }
        if (model instanceof LangIdentNeuralNetwork) {
            return LANG_IDENT;
        }
        return null;
    }

    private TrainedModelType(TrainedModelInput defaultInput) {
        this.defaultInput = defaultInput;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public TrainedModelInput getDefaultInput() {
        return this.defaultInput;
    }

    public TrainedModelLocation getDefaultLocation(String modelId) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> new IndexLocation(".ml-inference-000005");
            case 2 -> new IndexLocation(InferenceIndexConstants.nativeDefinitionStore());
        };
    }
}

