/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class MachineLearningFeatureSetUsage
extends XPackFeatureUsage {
    public static final String ALL = "_all";
    public static final String JOBS_FIELD = "jobs";
    public static final String DATAFEEDS_FIELD = "datafeeds";
    public static final String COUNT = "count";
    public static final String DETECTORS = "detectors";
    public static final String FORECASTS = "forecasts";
    public static final String MODEL_SIZE = "model_size";
    public static final String CREATED_BY = "created_by";
    public static final String NODE_COUNT = "node_count";
    public static final String DATA_FRAME_ANALYTICS_JOBS_FIELD = "data_frame_analytics_jobs";
    public static final String INFERENCE_FIELD = "inference";
    public static final String MEMORY_FIELD = "memory";
    private final Map<String, Object> jobsUsage;
    private final Map<String, Object> datafeedsUsage;
    private final Map<String, Object> analyticsUsage;
    private final Map<String, Object> inferenceUsage;
    private final Map<String, Object> memoryUsage;
    private final int nodeCount;

    public MachineLearningFeatureSetUsage(boolean available, boolean enabled, Map<String, Object> jobsUsage, Map<String, Object> datafeedsUsage, Map<String, Object> analyticsUsage, Map<String, Object> inferenceUsage, Map<String, Object> memoryUsage, int nodeCount) {
        super("ml", available, enabled);
        this.jobsUsage = Objects.requireNonNull(jobsUsage);
        this.datafeedsUsage = Objects.requireNonNull(datafeedsUsage);
        this.analyticsUsage = Objects.requireNonNull(analyticsUsage);
        this.inferenceUsage = Objects.requireNonNull(inferenceUsage);
        this.memoryUsage = Objects.requireNonNull(memoryUsage);
        this.nodeCount = nodeCount;
    }

    public MachineLearningFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.jobsUsage = in.readGenericMap();
        this.datafeedsUsage = in.readGenericMap();
        this.analyticsUsage = in.readGenericMap();
        this.inferenceUsage = in.readGenericMap();
        this.nodeCount = in.readInt();
        this.memoryUsage = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? in.readGenericMap() : Map.of();
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeGenericMap(this.jobsUsage);
        out.writeGenericMap(this.datafeedsUsage);
        out.writeGenericMap(this.analyticsUsage);
        out.writeGenericMap(this.inferenceUsage);
        out.writeInt(this.nodeCount);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            out.writeGenericMap(this.memoryUsage);
        }
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field(JOBS_FIELD, this.jobsUsage);
        builder.field(DATAFEEDS_FIELD, this.datafeedsUsage);
        builder.field(DATA_FRAME_ANALYTICS_JOBS_FIELD, this.analyticsUsage);
        builder.field(INFERENCE_FIELD, this.inferenceUsage);
        builder.field(MEMORY_FIELD, this.memoryUsage);
        if (this.nodeCount >= 0) {
            builder.field(NODE_COUNT, this.nodeCount);
        }
    }

    public Map<String, Object> getJobsUsage() {
        return this.jobsUsage;
    }

    public Map<String, Object> getDatafeedsUsage() {
        return this.datafeedsUsage;
    }

    public Map<String, Object> getAnalyticsUsage() {
        return this.analyticsUsage;
    }

    public Map<String, Object> getInferenceUsage() {
        return this.inferenceUsage;
    }

    public Map<String, Object> getMemoryUsage() {
        return this.memoryUsage;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineLearningFeatureSetUsage that = (MachineLearningFeatureSetUsage)o;
        return this.nodeCount == that.nodeCount && Objects.equals(this.jobsUsage, that.jobsUsage) && Objects.equals(this.datafeedsUsage, that.datafeedsUsage) && Objects.equals(this.analyticsUsage, that.analyticsUsage) && Objects.equals(this.inferenceUsage, that.inferenceUsage) && Objects.equals(this.memoryUsage, that.memoryUsage);
    }

    public int hashCode() {
        return Objects.hash(this.jobsUsage, this.datafeedsUsage, this.analyticsUsage, this.inferenceUsage, this.memoryUsage, this.nodeCount);
    }
}

