/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.TransportVersion;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.ResponseStatsConsumer;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;

public final class TcpTransportChannel
implements TransportChannel {
    private final OutboundHandler outboundHandler;
    private final TcpChannel channel;
    private final String action;
    private final long requestId;
    private final TransportVersion version;
    private final Compression.Scheme compressionScheme;
    private final ResponseStatsConsumer responseStatsConsumer;
    private final boolean isHandshake;
    private final Releasable breakerRelease;

    TcpTransportChannel(OutboundHandler outboundHandler, TcpChannel channel, String action, long requestId, TransportVersion version, Compression.Scheme compressionScheme, ResponseStatsConsumer responseStatsConsumer, boolean isHandshake, Releasable breakerRelease) {
        this.version = version;
        this.channel = channel;
        this.outboundHandler = outboundHandler;
        this.action = action;
        this.requestId = requestId;
        this.compressionScheme = compressionScheme;
        this.responseStatsConsumer = responseStatsConsumer;
        this.isHandshake = isHandshake;
        this.breakerRelease = breakerRelease;
    }

    @Override
    public String getProfileName() {
        return this.channel.getProfile();
    }

    @Override
    public void sendResponse(TransportResponse response) {
        try {
            this.outboundHandler.sendResponse(this.version, this.channel, this.requestId, this.action, response, this.compressionScheme, this.isHandshake, this.responseStatsConsumer);
        }
        finally {
            this.breakerRelease.close();
        }
    }

    @Override
    public void sendResponse(Exception exception) {
        try {
            this.outboundHandler.sendErrorResponse(this.version, this.channel, this.requestId, this.action, this.responseStatsConsumer, exception);
        }
        finally {
            this.breakerRelease.close();
        }
    }

    @Override
    public TransportVersion getVersion() {
        return this.version;
    }

    public TcpChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "TcpTransportChannel{req=" + this.requestId + "}{" + this.action + "}{" + String.valueOf(this.channel) + "}";
    }
}

