/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import com.carrotsearch.hppc.BitMixer;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.InternalCardinality;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class CardinalityAggregator
extends NumericMetricsAggregator.SingleValue {
    private final int precision;
    private final CardinalityAggregatorFactory.ExecutionMode executionMode;
    private final ValuesSource valuesSource;
    private final HyperLogLogPlusPlus counts;
    private Collector collector;
    private int emptyCollectorsUsed;
    private int numericCollectorsUsed;
    private int ordinalsCollectorsUsed;
    private int ordinalsCollectorsOverheadTooHigh;
    private int stringHashingCollectorsUsed;

    public CardinalityAggregator(String name, ValuesSourceConfig valuesSourceConfig, int precision, CardinalityAggregatorFactory.ExecutionMode executionMode, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = valuesSourceConfig.getValuesSource();
        this.precision = precision;
        this.counts = new HyperLogLogPlusPlus(precision, context.bigArrays(), 1L);
        this.executionMode = executionMode;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    private Collector pickCollector(LeafReaderContext ctx) throws IOException {
        Object values;
        ValuesSource valuesSource = this.valuesSource;
        if (valuesSource instanceof ValuesSource.Numeric) {
            ValuesSource.Numeric source = (ValuesSource.Numeric)valuesSource;
            ++this.numericCollectorsUsed;
            if (source.isFloatingPoint()) {
                values = source.doubleValues(ctx);
                NumericDoubleValues singleton = FieldData.unwrapSingleton((SortedNumericDoubleValues)values);
                if (singleton != null) {
                    return new DirectSingleValuesCollector(this.counts, MurmurHash3SingleValues.hash(singleton));
                }
                return new DirectMultiValuesCollector(this.counts, MurmurHash3MultiValues.hash((SortedNumericDoubleValues)values));
            }
            values = source.longValues(ctx);
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            if (singleton != null) {
                return new DirectSingleValuesCollector(this.counts, MurmurHash3SingleValues.hash(singleton));
            }
            return new DirectMultiValuesCollector(this.counts, MurmurHash3MultiValues.hash((SortedNumericDocValues)values));
        }
        values = this.valuesSource;
        if (values instanceof ValuesSource.Bytes.WithOrdinals) {
            ValuesSource.Bytes.WithOrdinals source = (ValuesSource.Bytes.WithOrdinals)values;
            SortedSetDocValues ordinalValues = source.ordinalsValues(ctx);
            long maxOrd = ordinalValues.getValueCount();
            if (maxOrd == 0L) {
                ++this.emptyCollectorsUsed;
                return new EmptyCollector();
            }
            if (this.executionMode.useSegmentOrdinals(maxOrd, this.precision)) {
                ++this.ordinalsCollectorsUsed;
                return new OrdinalsCollector(this.counts, ordinalValues, this.bigArrays());
            }
            if (this.executionMode.isHeuristicBased()) {
                ++this.ordinalsCollectorsOverheadTooHigh;
            }
        }
        ++this.stringHashingCollectorsUsed;
        SortedBinaryDocValues values2 = this.valuesSource.bytesValues(ctx);
        BinaryDocValues singleton = FieldData.unwrapSingleton(values2);
        if (singleton != null) {
            return new DirectSingleValuesCollector(this.counts, MurmurHash3SingleValues.hash(singleton));
        }
        return new DirectMultiValuesCollector(this.counts, MurmurHash3MultiValues.hash(values2));
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        this.postCollectLastCollector();
        this.collector = this.pickCollector(aggCtx.getLeafReaderContext());
        return this.collector;
    }

    private void postCollectLastCollector() throws IOException {
        if (this.collector != null) {
            try {
                this.collector.postCollect();
            }
            finally {
                this.collector.close();
                this.collector = null;
            }
        }
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.postCollectLastCollector();
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.counts.cardinality(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (owningBucketOrdinal >= this.counts.maxOrd() || this.counts.cardinality(owningBucketOrdinal) == 0L) {
            return this.buildEmptyAggregation();
        }
        AbstractHyperLogLogPlusPlus copy = this.counts.clone(owningBucketOrdinal, BigArrays.NON_RECYCLING_INSTANCE);
        return new InternalCardinality(this.name, copy, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalCardinality.empty(this.name, this.metadata());
    }

    @Override
    protected void doClose() {
        Releasables.close(this.counts, this.collector);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("empty_collectors_used", this.emptyCollectorsUsed);
        add.accept("numeric_collectors_used", this.numericCollectorsUsed);
        add.accept("ordinals_collectors_used", this.ordinalsCollectorsUsed);
        add.accept("ordinals_collectors_overhead_too_high", this.ordinalsCollectorsOverheadTooHigh);
        add.accept("string_hashing_collectors_used", this.stringHashingCollectorsUsed);
    }

    private static class DirectSingleValuesCollector
    extends DirectCollector {
        private final MurmurHash3SingleValues hashes;

        DirectSingleValuesCollector(HyperLogLogPlusPlus counts, MurmurHash3SingleValues values) {
            super(counts);
            this.hashes = values;
        }

        @Override
        public void collect(int doc, long bucketOrd) throws IOException {
            if (this.hashes.advanceExact(doc)) {
                this.counts.collect(bucketOrd, this.hashes.longValue());
            }
        }
    }

    private static abstract class MurmurHash3SingleValues {
        private MurmurHash3SingleValues() {
        }

        public abstract boolean advanceExact(int var1) throws IOException;

        public abstract long longValue() throws IOException;

        public static MurmurHash3SingleValues hash(NumericDoubleValues values) {
            return new Double(values);
        }

        public static MurmurHash3SingleValues hash(NumericDocValues values) {
            return new Long(values);
        }

        public static MurmurHash3SingleValues hash(BinaryDocValues values) {
            return new Bytes(values);
        }

        private static class Double
        extends MurmurHash3SingleValues {
            private final NumericDoubleValues values;

            Double(NumericDoubleValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public long longValue() throws IOException {
                return BitMixer.mix64((long)java.lang.Double.doubleToLongBits(this.values.doubleValue()));
            }
        }

        private static class Long
        extends MurmurHash3SingleValues {
            private final NumericDocValues values;

            Long(NumericDocValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public long longValue() throws IOException {
                return BitMixer.mix64((long)this.values.longValue());
            }
        }

        private static class Bytes
        extends MurmurHash3SingleValues {
            private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
            private final BinaryDocValues values;

            Bytes(BinaryDocValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public long longValue() throws IOException {
                BytesRef bytes = this.values.binaryValue();
                MurmurHash3.hash128(bytes.bytes, bytes.offset, bytes.length, 0L, this.hash);
                return this.hash.h1;
            }
        }
    }

    private static class DirectMultiValuesCollector
    extends DirectCollector {
        private final MurmurHash3MultiValues hashes;

        DirectMultiValuesCollector(HyperLogLogPlusPlus counts, MurmurHash3MultiValues values) {
            super(counts);
            this.hashes = values;
        }

        @Override
        public void collect(int doc, long bucketOrd) throws IOException {
            if (this.hashes.advanceExact(doc)) {
                int valueCount = this.hashes.count();
                for (int i = 0; i < valueCount; ++i) {
                    this.counts.collect(bucketOrd, this.hashes.nextValue());
                }
            }
        }
    }

    private static abstract class MurmurHash3MultiValues {
        private MurmurHash3MultiValues() {
        }

        public abstract boolean advanceExact(int var1) throws IOException;

        public abstract int count();

        public abstract long nextValue() throws IOException;

        public static MurmurHash3MultiValues hash(SortedNumericDoubleValues values) {
            return new Double(values);
        }

        public static MurmurHash3MultiValues hash(SortedNumericDocValues values) {
            return new Long(values);
        }

        public static MurmurHash3MultiValues hash(SortedBinaryDocValues values) {
            return new Bytes(values);
        }

        private static class Double
        extends MurmurHash3MultiValues {
            private final SortedNumericDoubleValues values;

            Double(SortedNumericDoubleValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                return BitMixer.mix64((long)java.lang.Double.doubleToLongBits(this.values.nextValue()));
            }
        }

        private static class Long
        extends MurmurHash3MultiValues {
            private final SortedNumericDocValues values;

            Long(SortedNumericDocValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                return BitMixer.mix64((long)this.values.nextValue());
            }
        }

        private static class Bytes
        extends MurmurHash3MultiValues {
            private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
            private final SortedBinaryDocValues values;

            Bytes(SortedBinaryDocValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                BytesRef bytes = this.values.nextValue();
                MurmurHash3.hash128(bytes.bytes, bytes.offset, bytes.length, 0L, this.hash);
                return this.hash.h1;
            }
        }
    }

    private static class EmptyCollector
    extends Collector {
        private EmptyCollector() {
        }

        @Override
        public void collect(int doc, long bucketOrd) {
        }

        @Override
        public void postCollect() {
        }

        @Override
        public void close() {
        }
    }

    static class OrdinalsCollector
    extends Collector {
        private static final long SHALLOW_FIXEDBITSET_SIZE = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
        private final BigArrays bigArrays;
        private final SortedSetDocValues values;
        private final int maxOrd;
        private final HyperLogLogPlusPlus counts;
        private ObjectArray<BitArray> visitedOrds;

        public static long memoryOverhead(long maxOrd) {
            return (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + SHALLOW_FIXEDBITSET_SIZE + (maxOrd + 7L) / 8L;
        }

        OrdinalsCollector(HyperLogLogPlusPlus counts, SortedSetDocValues values, BigArrays bigArrays) {
            if (values.getValueCount() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.maxOrd = (int)values.getValueCount();
            this.bigArrays = bigArrays;
            this.counts = counts;
            this.values = values;
            this.visitedOrds = bigArrays.newObjectArray(1L);
        }

        @Override
        public void collect(int doc, long bucketOrd) throws IOException {
            if (this.values.advanceExact(doc)) {
                this.visitedOrds = this.bigArrays.grow(this.visitedOrds, bucketOrd + 1L);
                BitArray bits = this.visitedOrds.get(bucketOrd);
                if (bits == null) {
                    bits = new BitArray(this.maxOrd, this.bigArrays);
                    this.visitedOrds.set(bucketOrd, bits);
                }
                for (int i = 0; i < this.values.docValueCount(); ++i) {
                    long ord = this.values.nextOrd();
                    bits.set((int)ord);
                }
            }
        }

        @Override
        public void postCollect() throws IOException {
            try (BitArray allVisitedOrds = new BitArray(this.maxOrd, this.bigArrays);){
                for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                    BitArray bits = this.visitedOrds.get(bucket);
                    if (bits == null) continue;
                    allVisitedOrds.or(bits);
                }
                try (LongArray hashes = this.bigArrays.newLongArray(this.maxOrd, false);){
                    MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
                    long ord = allVisitedOrds.nextSetBit(0L);
                    while (ord < Long.MAX_VALUE) {
                        BytesRef value = this.values.lookupOrd(ord);
                        MurmurHash3.hash128(value.bytes, value.offset, value.length, 0L, hash);
                        hashes.set(ord, hash.h1);
                        ord = ord + 1L < (long)this.maxOrd ? allVisitedOrds.nextSetBit(ord + 1L) : Long.MAX_VALUE;
                    }
                    for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                        BitArray bits = this.visitedOrds.get(bucket);
                        if (bits == null) continue;
                        long ord2 = bits.nextSetBit(0L);
                        while (ord2 < Long.MAX_VALUE) {
                            this.counts.collect(bucket, hashes.get(ord2));
                            ord2 = ord2 + 1L < (long)this.maxOrd ? bits.nextSetBit(ord2 + 1L) : Long.MAX_VALUE;
                        }
                    }
                }
            }
        }

        @Override
        public void close() {
            int i = 0;
            while ((long)i < this.visitedOrds.size()) {
                Releasables.close((Releasable)this.visitedOrds.get(i));
                ++i;
            }
            Releasables.close(this.visitedOrds);
        }
    }

    private static abstract class Collector
    extends LeafBucketCollector
    implements Releasable {
        private Collector() {
        }

        public abstract void postCollect() throws IOException;
    }

    private static abstract class DirectCollector
    extends Collector {
        protected final HyperLogLogPlusPlus counts;

        DirectCollector(HyperLogLogPlusPlus counts) {
            this.counts = counts;
        }

        @Override
        public void postCollect() {
        }

        @Override
        public void close() {
        }
    }
}

