/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;

public final class AggregatorsReducer
implements Releasable {
    private final Map<String, AggregatorReducer> aggByName;
    private final AggregationReduceContext context;
    private final int size;

    public AggregatorsReducer(InternalAggregations proto, AggregationReduceContext context, int size) {
        this.context = context;
        this.size = size;
        this.aggByName = new HashMap<String, AggregatorReducer>(proto.asList().size());
    }

    public void accept(InternalAggregations aggregations) {
        for (InternalAggregation aggregation : aggregations) {
            AggregatorReducer reducer = this.aggByName.computeIfAbsent(aggregation.getName(), k -> aggregation.getReducer(this.context.forAgg(aggregation.getName()), this.size));
            reducer.accept(aggregation);
        }
    }

    public InternalAggregations get() {
        Collection<AggregatorReducer> reducers = this.aggByName.values();
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(reducers.size());
        for (AggregatorReducer reducer : reducers) {
            aggs.add(reducer.get());
        }
        return InternalAggregations.from(aggs);
    }

    @Override
    public void close() {
        Releasables.close(this.aggByName.values());
    }
}

