/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorCollector;
import org.elasticsearch.search.aggregations.AggregatorCollectorManager;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.support.TimeSeriesIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class AggregationPhase {
    private AggregationPhase() {
    }

    public static void preProcess(SearchContext context) {
        Supplier<AggregatorCollector> collectorSupplier;
        if (context.aggregations() == null) {
            return;
        }
        if (context.aggregations().isInSortOrderExecutionRequired()) {
            AggregatorCollector collector = AggregationPhase.newAggregatorCollector(context);
            AggregationPhase.executeInSortOrder(context, collector.bucketCollector);
            collectorSupplier = () -> new AggregatorCollector(collector.aggregators, BucketCollector.NO_OP_BUCKET_COLLECTOR);
        } else {
            collectorSupplier = () -> AggregationPhase.newAggregatorCollector(context);
        }
        context.aggregations().registerAggsCollectorManager(new AggregatorCollectorManager(collectorSupplier, internalAggregations -> context.queryResult().aggregations((InternalAggregations)internalAggregations), () -> context.aggregations().getAggregationReduceContextBuilder().forPartialReduction()));
    }

    private static AggregatorCollector newAggregatorCollector(SearchContext context) {
        try {
            Aggregator[] aggregators = context.aggregations().factories().createTopLevelAggregators();
            BucketCollector bucketCollector = MultiBucketCollector.wrap(true, List.of(aggregators));
            bucketCollector.preCollection();
            return new AggregatorCollector(aggregators, bucketCollector);
        }
        catch (IOException e) {
            throw new AggregationInitializationException("Could not initialize aggregators", e);
        }
    }

    private static void executeInSortOrder(SearchContext context, BucketCollector collector) {
        TimeSeriesIndexSearcher searcher = new TimeSeriesIndexSearcher(context.searcher(), context.getCancellationChecks());
        searcher.setMinimumScore(context.minimumScore());
        searcher.setProfiler(context);
        try {
            searcher.search(context.rewrittenQuery(), collector);
        }
        catch (IOException e) {
            throw new AggregationExecutionException("Could not perform time series aggregation", e);
        }
    }
}

