/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;

public class FloatDocValuesField
extends AbstractScriptFieldFactory<Float>
implements Field<Float>,
DocValuesScriptFieldFactory,
ScriptDocValues.Supplier<Double> {
    protected final SortedNumericDoubleValues input;
    protected final String name;
    protected float[] values = new float[0];
    protected int count;
    private ScriptDocValues.Doubles doubles = null;

    public FloatDocValuesField(SortedNumericDoubleValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = (float)this.input.nextValue();
            }
        } else {
            this.resize(0);
        }
    }

    protected void resize(int newSize) {
        this.count = newSize;
        assert (this.count >= 0) : "size must be positive (got " + this.count + "): likely integer overflow?";
        this.values = ArrayUtil.grow(this.values, this.count);
    }

    public ScriptDocValues<Double> toScriptDocValues() {
        if (this.doubles == null) {
            this.doubles = new ScriptDocValues.Doubles(this);
        }
        return this.doubles;
    }

    @Override
    public Double getInternal(int index) {
        return this.values[index];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FloatDocValuesField.this.count;
            }

            @Override
            public Float next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Float.valueOf(FloatDocValuesField.this.values[this.index++]);
            }
        };
    }

    public float get(float defaultValue) {
        return this.get(0, defaultValue);
    }

    public float get(int index, float defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.values[index];
    }
}

