/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record ScriptCacheStats(Map<String, ScriptStats> context, ScriptStats general) implements Writeable,
ToXContentFragment
{
    public ScriptCacheStats(Map<String, ScriptStats> context) {
        this(Collections.unmodifiableMap(context), null);
    }

    public ScriptCacheStats(ScriptStats general) {
        this(null, Objects.requireNonNull(general));
    }

    public static ScriptCacheStats read(StreamInput in) throws IOException {
        boolean isContext = in.readBoolean();
        if (!isContext) {
            return new ScriptCacheStats(ScriptStats.read(in));
        }
        int size = in.readInt();
        Map<String, ScriptStats> context = Maps.newMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readString();
            context.put(name, ScriptStats.read(in));
        }
        return new ScriptCacheStats(context);
    }

    private Map.Entry<String, ScriptStats>[] sortedContextStats() {
        Map.Entry[] stats = (Map.Entry[])this.context.entrySet().toArray(Map.Entry[]::new);
        Arrays.sort(stats, Map.Entry.comparingByKey());
        return stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.general != null) {
            out.writeBoolean(false);
            this.general.writeTo(out);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.context.size());
        for (Map.Entry<String, ScriptStats> stats : this.sortedContextStats()) {
            out.writeString(stats.getKey());
            stats.getValue().writeTo(out);
        }
    }

    private static void scriptStatsToXContent(ScriptStats s, XContentBuilder builder) throws IOException {
        builder.field("compilations", s.getCompilations());
        builder.field("cache_evictions", s.getCacheEvictions());
        builder.field("compilation_limit_triggered", s.getCompilationLimitTriggered());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("script_cache");
        builder.startObject("sum");
        if (this.general != null) {
            ScriptCacheStats.scriptStatsToXContent(this.general, builder);
            builder.endObject().endObject();
            return builder;
        }
        ScriptCacheStats.scriptStatsToXContent(this.sum(), builder);
        builder.endObject();
        builder.startArray("contexts");
        for (Map.Entry<String, ScriptStats> stats : this.sortedContextStats()) {
            builder.startObject();
            builder.field("context", stats.getKey());
            ScriptCacheStats.scriptStatsToXContent(stats.getValue(), builder);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public Map<String, ScriptStats> getContextStats() {
        return this.context;
    }

    public ScriptStats getGeneralStats() {
        return this.general;
    }

    public ScriptStats sum() {
        if (this.general != null) {
            return this.general;
        }
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptStats stat : this.context.values()) {
            compilations += stat.getCompilations();
            cacheEvictions += stat.getCacheEvictions();
            compilationLimitTriggered += stat.getCompilationLimitTriggered();
        }
        return new ScriptStats(compilations, cacheEvictions, compilationLimitTriggered, null, null);
    }

    static final class Fields {
        static final String SCRIPT_CACHE_STATS = "script_cache";
        static final String CONTEXT = "context";
        static final String SUM = "sum";
        static final String CONTEXTS = "contexts";

        Fields() {
        }
    }
}

