/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.ParsedMediaType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public abstract class AbstractRestChannel
implements RestChannel {
    private static final Logger logger = LogManager.getLogger(AbstractRestChannel.class);
    private static final Predicate<String> INCLUDE_FILTER = f -> f.charAt(0) != '-';
    private static final Predicate<String> EXCLUDE_FILTER = INCLUDE_FILTER.negate();
    protected final RestRequest request;
    private final boolean detailedErrorsEnabled;
    private final String format;
    private final String filterPath;
    private final boolean pretty;
    private final boolean human;
    private final String acceptHeader;
    private BytesStream bytesOut;

    protected AbstractRestChannel(RestRequest request, boolean detailedErrorsEnabled) {
        this.request = request;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.format = request.param("format");
        this.acceptHeader = request.header("Accept");
        this.filterPath = request.param("filter_path", null);
        this.pretty = request.paramAsBoolean("pretty", false);
        this.human = request.paramAsBoolean("human", false);
    }

    @Override
    public XContentBuilder newBuilder() throws IOException {
        return this.newBuilder(this.request.getXContentType(), true);
    }

    @Override
    public XContentBuilder newErrorBuilder() throws IOException {
        this.releaseOutputBuffer();
        return this.newBuilder(this.request.getXContentType(), false);
    }

    @Override
    public XContentBuilder newBuilder(@Nullable XContentType requestContentType, boolean useFiltering) throws IOException {
        return this.newBuilder(requestContentType, null, useFiltering);
    }

    @Override
    public XContentBuilder newBuilder(@Nullable XContentType requestContentType, @Nullable XContentType responseContentType, boolean useFiltering) throws IOException {
        return this.newBuilder(requestContentType, responseContentType, useFiltering, Streams.flushOnCloseStream(this.bytesOutput()));
    }

    @Override
    public XContentBuilder newBuilder(@Nullable XContentType requestContentType, @Nullable XContentType responseContentType, boolean useFiltering, OutputStream outputStream) throws IOException {
        if (responseContentType == null) {
            if (Strings.hasText(this.format)) {
                responseContentType = XContentType.fromFormat(this.format);
            }
            if (responseContentType == null && Strings.hasText(this.acceptHeader)) {
                responseContentType = XContentType.fromMediaType(this.acceptHeader);
            }
        }
        if (responseContentType == null) {
            responseContentType = requestContentType != null ? requestContentType : XContentType.JSON;
        }
        Set<String> includes = Collections.emptySet();
        Set<String> excludes = Collections.emptySet();
        if (useFiltering) {
            Set<String> filters = Strings.tokenizeByCommaToSet(this.filterPath);
            includes = filters.stream().filter(INCLUDE_FILTER).collect(Collectors.toSet());
            excludes = filters.stream().filter(EXCLUDE_FILTER).map(f -> f.substring(1)).collect(Collectors.toSet());
        }
        Map<String, String> parameters = this.request.getParsedAccept() != null ? this.request.getParsedAccept().getParameters() : Collections.emptyMap();
        ParsedMediaType responseMediaType = ParsedMediaType.parseMediaType(responseContentType, parameters);
        XContentBuilder builder = new XContentBuilder(XContentFactory.xContent(responseContentType), outputStream, includes, excludes, responseMediaType, this.request.getRestApiVersion());
        if (this.pretty) {
            builder.prettyPrint().lfAtEnd();
        }
        builder.humanReadable(this.human);
        return builder;
    }

    @Override
    public final BytesStream bytesOutput() {
        if (this.bytesOut != null) {
            assert (false) : "getting here is always a bug";
            logger.error("channel handling [{}] reused", (Object)this.request.rawPath());
            this.releaseOutputBuffer();
        }
        this.bytesOut = this.newBytesOutput();
        return this.bytesOut;
    }

    @Override
    public final void releaseOutputBuffer() {
        if (this.bytesOut != null) {
            try {
                this.bytesOut.close();
            }
            catch (IOException e) {
                assert (false) : e;
                throw new UncheckedIOException(e);
            }
            this.bytesOut = null;
        }
    }

    protected BytesStream newBytesOutput() {
        return new BytesStreamOutput();
    }

    @Override
    public RestRequest request() {
        return this.request;
    }

    @Override
    public boolean detailedErrorsEnabled() {
        return this.detailedErrorsEnabled;
    }
}

