/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class DeleteDatabaseConfigurationAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteDatabaseConfigurationAction INSTANCE = new DeleteDatabaseConfigurationAction();
    public static final String NAME = "cluster:admin/ingest/geoip/database/delete";

    protected DeleteDatabaseConfigurationAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String databaseId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.databaseId = in.readString();
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String databaseId) {
            super(masterNodeTimeout, ackTimeout);
            this.databaseId = Objects.requireNonNull(databaseId, "id may not be null");
        }

        public String getDatabaseId() {
            return this.databaseId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.databaseId);
        }

        public int hashCode() {
            return this.databaseId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.databaseId, other.databaseId);
        }
    }
}

