/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.SeqNoDocValuesField;

public class SeqNoFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_seq_no";
    public static final String CONTENT_TYPE = "_seq_no";
    public static final String PRIMARY_TERM_NAME = "_primary_term";
    public static final String TOMBSTONE_NAME = "_tombstone";
    public static final SeqNoFieldMapper WITH_POINT = new SeqNoFieldMapper(true);
    public static final SeqNoFieldMapper NO_POINT = new SeqNoFieldMapper(false);
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> switch (c.getIndexSettings().seqNoIndexOptions().ordinal()) {
        default -> throw new MatchException(null, null);
        case 1 -> WITH_POINT;
        case 0 -> NO_POINT;
    });

    private SeqNoFieldMapper(boolean indexedPoints) {
        super(indexedPoints ? SeqNoFieldType.WITH_POINT : SeqNoFieldType.NO_POINT);
    }

    @Override
    public void postParse(DocumentParserContext context) {
        SequenceIDFields seqID = context.seqID();
        seqID.addFields(context.doc());
        for (LuceneDocument doc : context.nonRootDocuments()) {
            doc.add(seqID.seqNo);
        }
    }

    @Override
    protected String contentType() {
        return "_seq_no";
    }

    private static Query rangeQueryForSeqNo(boolean withPoints, long lowerValue, long upperValue) {
        if (withPoints) {
            return LongPoint.newRangeQuery("_seq_no", lowerValue, upperValue);
        }
        return NumericDocValuesField.newSlowRangeQuery("_seq_no", lowerValue, upperValue);
    }

    public static Query rangeQueryForSeqNo(SeqNoIndexOptions seqNoIndexOptions, long lowerValue, long upperValue) {
        return switch (seqNoIndexOptions.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> SeqNoFieldMapper.rangeQueryForSeqNo(true, lowerValue, upperValue);
            case 0 -> SeqNoFieldMapper.rangeQueryForSeqNo(false, lowerValue, upperValue);
        };
    }

    static final class SeqNoFieldType
    extends SimpleMappedFieldType {
        private static final SeqNoFieldType WITH_POINT = new SeqNoFieldType(true);
        private static final SeqNoFieldType NO_POINT = new SeqNoFieldType(false);

        private SeqNoFieldType(boolean indexed) {
            super("_seq_no", indexed, false, true, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_seq_no";
        }

        private static long parse(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for a long");
                }
                if (doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Long.parseLong(value.toString());
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return false;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new IllegalArgumentException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query termQuery(Object value, @Nullable SearchExecutionContext context) {
            long v = SeqNoFieldType.parse(value);
            if (this.isIndexed()) {
                return LongPoint.newExactQuery(this.name(), v);
            }
            return NumericDocValuesField.newSlowExactQuery(this.name(), v);
        }

        @Override
        public Query termsQuery(Collection<?> values, @Nullable SearchExecutionContext context) {
            long[] v = values.stream().mapToLong(SeqNoFieldType::parse).toArray();
            if (this.isIndexed()) {
                return LongPoint.newSetQuery(this.name(), v);
            }
            return NumericDocValuesField.newSlowSetQuery(this.name(), v);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = SeqNoFieldType.parse(lowerTerm);
                if (!includeLower) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = SeqNoFieldType.parse(upperTerm);
                if (!includeUpper) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return SeqNoFieldMapper.rangeQueryForSeqNo(this.isIndexed(), l, u);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG, SeqNoDocValuesField::new, this.isIndexed());
        }

        @Override
        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }
    }

    public static class SequenceIDFields {
        private static final Field TOMBSTONE_FIELD = new NumericDocValuesField("_tombstone", 1L);
        private final Field seqNo;
        private final Field primaryTerm = new NumericDocValuesField("_primary_term", 0L);
        private final boolean isTombstone;

        private SequenceIDFields(SeqNoIndexOptions seqNoIndexOptions, boolean isTombstone) {
            this.isTombstone = isTombstone;
            this.seqNo = switch (seqNoIndexOptions.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> new SingleValueLongField("_seq_no");
                case 0 -> NumericDocValuesField.indexedField("_seq_no", -2L);
            };
        }

        public void addFields(LuceneDocument document) {
            document.add(this.seqNo);
            document.add(this.primaryTerm);
            if (this.isTombstone) {
                document.add(TOMBSTONE_FIELD);
            }
        }

        public void set(long seqNo, long primaryTerm) {
            this.seqNo.setLongValue(seqNo);
            this.primaryTerm.setLongValue(primaryTerm);
        }

        public static SequenceIDFields emptySeqID(SeqNoIndexOptions seqNoIndexOptions) {
            return new SequenceIDFields(seqNoIndexOptions, false);
        }

        public static SequenceIDFields tombstone(SeqNoIndexOptions seqNoIndexOptions) {
            return new SequenceIDFields(seqNoIndexOptions, true);
        }
    }

    public static enum SeqNoIndexOptions {
        DOC_VALUES_ONLY,
        POINTS_AND_DOC_VALUES;

    }

    private static class SingleValueLongField
    extends Field {
        private static final FieldType FIELD_TYPE;

        SingleValueLongField(String field) {
            super(field, FIELD_TYPE);
            this.fieldsData = -2L;
        }

        @Override
        public BytesRef binaryValue() {
            byte[] pointValue = new byte[8];
            NumericUtils.longToSortableBytes((Long)this.fieldsData, pointValue, 0);
            return new BytesRef(pointValue);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + " <" + this.name + ":" + String.valueOf(this.fieldsData) + ">";
        }

        static {
            FieldType ft = new FieldType();
            ft.setDimensions(1, 8);
            ft.setDocValuesType(DocValuesType.NUMERIC);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType(ft);
        }
    }
}

