/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsAccounting;
import org.elasticsearch.index.fielddata.ordinals.SingletonGlobalOrdinalMapping;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public final class GlobalOrdinalsIndexFieldData
implements IndexOrdinalsFieldData,
Accountable,
GlobalOrdinalsAccounting {
    private final String fieldName;
    private final ValuesSourceType valuesSourceType;
    private final long memorySizeInBytes;
    private final OrdinalMap ordinalMap;
    private final LeafOrdinalsFieldData[] segmentAfd;
    private final ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory;
    private final TimeValue took;

    GlobalOrdinalsIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, LeafOrdinalsFieldData[] segmentAfd, OrdinalMap ordinalMap, long memorySizeInBytes, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory, TimeValue took) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
        this.memorySizeInBytes = memorySizeInBytes;
        this.ordinalMap = ordinalMap;
        this.segmentAfd = segmentAfd;
        this.toScriptFieldFactory = toScriptFieldFactory;
        this.took = took;
    }

    public IndexOrdinalsFieldData newConsumer(DirectoryReader source) {
        return new Consumer(source);
    }

    @Override
    public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) {
        throw new IllegalStateException("loadDirect(LeafReaderContext) should not be called in this context");
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        return this;
    }

    @Override
    public IndexOrdinalsFieldData loadGlobalDirect(DirectoryReader indexReader) {
        return this;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new UnsupportedOperationException("no global ordinals sorting yet");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    @Override
    public long ramBytesUsed() {
        return this.memorySizeInBytes;
    }

    @Override
    public LeafOrdinalsFieldData load(LeafReaderContext context) {
        throw new IllegalStateException("load(LeafReaderContext) should not be called in this context");
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return this.ordinalMap;
    }

    @Override
    public boolean supportsGlobalOrdinalsMapping() {
        return true;
    }

    @Override
    public long getValueCount() {
        return this.ordinalMap.getValueCount();
    }

    @Override
    public TimeValue getBuildingTime() {
        return this.took;
    }

    public class Consumer
    implements IndexOrdinalsFieldData,
    Accountable {
        private final DirectoryReader source;
        private TermsEnum[] lookups;

        Consumer(DirectoryReader source) {
            this.source = source;
        }

        private TermsEnum[] getOrLoadTermsEnums() {
            if (this.lookups == null) {
                this.lookups = new TermsEnum[GlobalOrdinalsIndexFieldData.this.segmentAfd.length];
                for (int i = 0; i < this.lookups.length; ++i) {
                    try {
                        this.lookups[i] = GlobalOrdinalsIndexFieldData.this.segmentAfd[i].getOrdinalsValues().termsEnum();
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to load terms enum", e);
                    }
                }
            }
            return this.lookups;
        }

        @Override
        public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) {
            return this.load(context);
        }

        @Override
        public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
            return this;
        }

        @Override
        public IndexOrdinalsFieldData loadGlobalDirect(DirectoryReader indexReader) {
            return this;
        }

        @Override
        public String getFieldName() {
            return GlobalOrdinalsIndexFieldData.this.fieldName;
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return GlobalOrdinalsIndexFieldData.this.valuesSourceType;
        }

        @Override
        public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
            throw new UnsupportedOperationException("no global ordinals sorting yet");
        }

        @Override
        public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
            throw new IllegalArgumentException("only supported on numeric fields");
        }

        @Override
        public long ramBytesUsed() {
            return GlobalOrdinalsIndexFieldData.this.memorySizeInBytes;
        }

        @Override
        public LeafOrdinalsFieldData load(final LeafReaderContext context) {
            assert (this.source.getReaderCacheHelper().getKey() == context.parent.reader().getReaderCacheHelper().getKey());
            return new AbstractLeafOrdinalsFieldData(GlobalOrdinalsIndexFieldData.this.toScriptFieldFactory){

                @Override
                public SortedSetDocValues getOrdinalsValues() {
                    SortedSetDocValues values = GlobalOrdinalsIndexFieldData.this.segmentAfd[context.ord].getOrdinalsValues();
                    if (values.getValueCount() == GlobalOrdinalsIndexFieldData.this.ordinalMap.getValueCount()) {
                        return values;
                    }
                    TermsEnum[] atomicLookups = Consumer.this.getOrLoadTermsEnums();
                    SortedSetDocValues singleton = SingletonGlobalOrdinalMapping.singletonIfPossible(GlobalOrdinalsIndexFieldData.this.ordinalMap, values, atomicLookups, context.ord);
                    return singleton == null ? new GlobalOrdinalMapping(GlobalOrdinalsIndexFieldData.this.ordinalMap, values, atomicLookups, context.ord) : singleton;
                }

                @Override
                public long ramBytesUsed() {
                    return GlobalOrdinalsIndexFieldData.this.segmentAfd[context.ord].ramBytesUsed();
                }

                @Override
                public Collection<Accountable> getChildResources() {
                    return GlobalOrdinalsIndexFieldData.this.segmentAfd[context.ord].getChildResources();
                }
            };
        }

        @Override
        public boolean supportsGlobalOrdinalsMapping() {
            return true;
        }

        @Override
        public OrdinalMap getOrdinalMap() {
            return GlobalOrdinalsIndexFieldData.this.ordinalMap;
        }
    }
}

